/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.common.util.StringInputStream;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ADFWlsRuntimeLifecycleListener
implements WlsRuntimeSpy.IListener {
    public void handleEvent(IRuntime runtime, WlsRuntimeSpy.EventType type) {
        IPath rtLocation = runtime.getLocation();
        if (rtLocation == null) {
            return;
        }
        File wlhome = rtLocation.toFile();
        File mwHome = WlsRuntimeUtil.getMwHome((File)wlhome);
        File fmwTemplatesDir = new File(mwHome, "/oracle_common/common/templates/applications");
        this.addSharedLibrariesFromTemplate(wlhome, fmwTemplatesDir, "jrf_template_", type);
        fmwTemplatesDir = new File(mwHome, "/oracle_common/common/templates/wls");
        this.addSharedLibrariesFromTemplate(wlhome, fmwTemplatesDir, "oracle.adf.template_", type);
        this.addSharedLibrariesFromTemplate(wlhome, fmwTemplatesDir, "oracle.jrf_template_", type);
    }

    private void addSharedLibrariesFromTemplate(File wlhome, File fmwTemplatesDir, String templateNamePrefix, WlsRuntimeSpy.EventType type) {
        if (fmwTemplatesDir.exists()) {
            File mwHome = WlsRuntimeUtil.getMwHome((File)wlhome);
            StringBuilder sb = new StringBuilder();
            File[] fileArray = fmwTemplatesDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block36: {
                    File f = fileArray[n2];
                    if (f.getName().startsWith(templateNamePrefix)) {
                        ZipInputStream zis = null;
                        try {
                            try {
                                zis = new ZipInputStream(new FileInputStream(f));
                                ZipEntry ze = zis.getNextEntry();
                                while (ze != null) {
                                    if (!ze.isDirectory() && ze.getName().endsWith("config.xml")) {
                                        byte[] data = new byte[1024];
                                        int n3 = zis.read(data);
                                        while (n3 > 0) {
                                            sb.append(new String(data, 0, n3, StandardCharsets.UTF_8));
                                            n3 = zis.read(data);
                                        }
                                        break;
                                    }
                                    ze = zis.getNextEntry();
                                }
                                zis.close();
                            }
                            catch (IOException e) {
                                String msg = String.valueOf(Resources.errorReadingADFTemplate) + f.getAbsolutePath();
                                ADFPlugin.logError(msg, e);
                                if (zis != null) {
                                    try {
                                        zis.close();
                                    }
                                    catch (IOException e2) {
                                        ADFPlugin.log(e2);
                                    }
                                }
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            if (zis != null) {
                                try {
                                    zis.close();
                                }
                                catch (IOException e) {
                                    ADFPlugin.log(e);
                                }
                            }
                            throw throwable;
                        }
                        if (zis != null) {
                            try {
                                zis.close();
                            }
                            catch (IOException e) {
                                ADFPlugin.log(e);
                            }
                        }
                    }
                }
                ++n2;
            }
            if (sb.length() > 0) {
                try {
                    Element rootNode = ADFWlsRuntimeLifecycleListener.parse(sb.toString());
                    NodeList nodes = rootNode.getChildNodes();
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element el;
                        String elName;
                        Node node = nodes.item(i);
                        if (node.getNodeType() == 1 && (elName = (el = (Element)node).getNodeName()).equals("library")) {
                            File location = null;
                            String name = null;
                            String specVersionStr = null;
                            String implVersionStr = null;
                            NodeList cnodes = el.getChildNodes();
                            int j = 0;
                            while (j < cnodes.getLength()) {
                                Node cnode = cnodes.item(j);
                                if (cnode.getNodeType() == 1) {
                                    Element childElement = (Element)cnode;
                                    if (childElement.getNodeName().equals("name")) {
                                        name = childElement.getChildNodes().item(0).getNodeValue();
                                        int n1 = name.indexOf(35);
                                        int n22 = name.indexOf(64);
                                        if (n1 > 0) {
                                            specVersionStr = name.substring(n1 + 1, n22);
                                            implVersionStr = name.substring(n22 + 1);
                                            name = name.substring(0, n1);
                                        }
                                    } else if (childElement.getNodeName().equals("source-path")) {
                                        String path = childElement.getChildNodes().item(0).getNodeValue();
                                        String orclHome = String.valueOf(mwHome.getAbsolutePath().replace('\\', '/')) + "/oracle_common";
                                        if (path.startsWith("$ORACLE_HOME$")) {
                                            path = path.replace("$ORACLE_HOME$", orclHome);
                                            location = new File(path);
                                        } else if (path.startsWith("$PRODUCT_HOME$")) {
                                            path = path.replace("$PRODUCT_HOME$", orclHome);
                                            location = new File(path);
                                        }
                                    }
                                }
                                ++j;
                            }
                            if (name != null && location != null && location.exists()) {
                                Version specVersion = specVersionStr == null ? null : new Version(specVersionStr);
                                Version implVersion = implVersionStr == null ? null : new Version(implVersionStr);
                                LibraryModuleRef ref = new LibraryModuleRef(name, specVersion, implVersion, false);
                                if (type == WlsRuntimeSpy.EventType.REFRESH && LibraryModulesSvc.getRegistry().isLibraryExisting(ref)) {
                                    return;
                                }
                                LibraryModulesSvc.registerLibraryModule((LibraryModuleRef)ref, (File)location);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    String msg = Resources.errRegisterADFSharedLib;
                    ADFPlugin.logError(msg, e);
                }
            }
        }
    }

    public static final Element parse(String xml) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            BufferedInputStream in = new BufferedInputStream((InputStream)new StringInputStream(xml));
            return builder.parse(in).getDocumentElement();
        }
        catch (Exception e) {
            String msg = Resources.errorParsingConfigXml;
            throw new CoreException(CorePlugin.createErrorStatus((String)msg, (Throwable)e));
        }
    }

    private static final class Resources
    extends NLS {
        public static String errRegisterADFSharedLib;
        public static String errorParsingConfigXml;
        public static String errorReadingADFTemplate;

        static {
            Resources.initializeMessages((String)ADFWlsRuntimeLifecycleListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

