/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.configuration.WebXMLConfiguration;
import oracle.eclipse.tools.adf.view.configuration.WebXmlConfigOperation;
import oracle.eclipse.tools.adf.view.internal.ADFFacetUtils;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.operations.AddDefaultRenderKitOperation;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CopyFileOperation;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.InstallFacetLibrariesOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryContainer;
import oracle.eclipse.tools.weblogic.syslib.IPathBasedSystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ADFWebFacetInstallDelegate
implements IDelegate {
    private static final long TIME_DIFF_SINCE_FILE_LAST_MODIFIED = 7500L;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
        try {
            try {
                CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
                compoundOperation.add((IOperation)new InstallFacetLibrariesOperation(project, (LibraryFacetInstallConfig)config));
                if (FacetedProjectUtilities.isProjectOfType((IProject)project, (String)"wls.web")) {
                    compoundOperation.add((IOperation)new AddADFDomainSharedLibrariesToClasspathOperation(project));
                }
                WebXmlConfigOperation webXmlConfigOperation = new WebXmlConfigOperation(Strings.webXmlConfigOperation, project);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.STATE_SAVING_METHOD_CONTEXT);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.TRINIDAD_CHECK_FILE_MOD_CONTEXT);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.VERSION_STRING_HIDDEN_CONTEXT);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.TRINIDAD_FILTER);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.ADF_SERVLET_FILTER);
                if (FacetedProjectUtilities.isProjectOfType((IProject)project, (String)"wls.web")) {
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER);
                } else {
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.GLASSFISH_ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER);
                }
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.RESOURCES_SERVLET);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.BIGRAPH_SERVLET);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.BIGAUGE_SERVLET);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.MAP_PROXY_SERVLET);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.GATEWAY_SERVLET);
                webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.JSP_JSFF_CONFIG);
                if (this.isAtLeastJSF20(project)) {
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_SKIP_COMMENTS);
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_ADF_FACELET_TAG_DECORATOR);
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_ADF_FACELET_RESOURCE_RESOLVER);
                    webXmlConfigOperation.stagingAddConfigTypes(WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_JSF_FACELET_VIEW_MAPPINGS);
                }
                compoundOperation.add((IOperation)webXmlConfigOperation);
                String configFileName = "WEB-INF/faces-config.xml";
                List configFiles = JSFAppConfigUtils.getConfigFilesFromContextParam((IProject)project);
                if (!configFiles.isEmpty()) {
                    configFileName = (String)configFiles.get(0);
                }
                compoundOperation.add((IOperation)new AddDefaultRenderKitOperation("oracle.adf.rich", project, configFileName));
                String WEB_CONTENT_FOLDER = OperationUtil.getWebContentFolderName((IProject)project);
                String SRC_FOLDER = OperationUtil.getSrcFolderName((IProject)project);
                compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/threeColumnTemplate.jspx", (IContainer)project, String.valueOf(WEB_CONTENT_FOLDER) + "/oracle/templates", false));
                compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/trinidad-config.xml", (IContainer)project, String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF", false));
                compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/adfc-config.xml", (IContainer)project, String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF", false));
                if (this.shouldOverwriteFile(project, String.valueOf(WEB_CONTENT_FOLDER) + "/index.jsp")) {
                    compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(WEB_CONTENT_FOLDER) + "/index.jsp"));
                    compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/index.jspx", (IContainer)project, WEB_CONTENT_FOLDER, false));
                }
                if (this.shouldOverwriteFile(project, String.valueOf(SRC_FOLDER) + "/resources/application.properties")) {
                    compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/application.properties", (IContainer)project, String.valueOf(SRC_FOLDER) + "/resources", true));
                }
                compoundOperation.add((IOperation)new AdjustDeploymentAssemblyOperation(project));
                compoundOperation.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100), null);
            }
            catch (ExecutionException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "One or more ADF facet install operations failed.", (Throwable)e));
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private boolean isAtLeastJSF20(IProject project) {
        return JSFVersion.guessAtLeast((JSFVersion)JSFVersion.V2_0, (IProject)project);
    }

    private boolean shouldOverwriteFile(IProject project, String relativePathForFile) {
        IFile file = project.getFile(relativePathForFile);
        return file.exists() && System.currentTimeMillis() - file.getLocalTimeStamp() < 7500L;
    }

    class AddADFDomainSharedLibrariesToClasspathOperation
    extends AbstractBasicOperation {
        IProject project;

        AddADFDomainSharedLibrariesToClasspathOperation(IProject proj) {
            super(Strings.addingADFDomainSharedLib);
            this.project = proj;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            LibraryModuleRef modRef = new LibraryModuleRef("adf.oracle.domain", null, null, true);
            try {
                SharedLibraryContainer.addToClasspath((IProject)this.project, (LibraryModuleRef)modRef);
                ISystemLibrariesContainerDef sysLibDef = SystemLibrariesContainer.getContainerDef((IProject)this.project);
                ElementList syslibs = sysLibDef.getSystemLibraries();
                IPathBasedSystemLibrary adfShareBaseJar = (IPathBasedSystemLibrary)syslibs.insert(IPathBasedSystemLibrary.TYPE);
                adfShareBaseJar.setLocationKey("ORACLE_COMMON_MODULES_DIR");
                adfShareBaseJar.setRelativePath("/oracle.adf.share.ca_11.1.1/adf-share-base.jar");
                IPathBasedSystemLibrary adfShareCaJar = (IPathBasedSystemLibrary)syslibs.insert(IPathBasedSystemLibrary.TYPE);
                adfShareCaJar.setLocationKey("ORACLE_COMMON_MODULES_DIR");
                adfShareCaJar.setRelativePath("/oracle.adf.share.ca_11.1.1/adf-share-ca.jar");
                sysLibDef.resource().save();
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            catch (ResourceStoreException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    private static final class AdjustDeploymentAssemblyOperation
    extends ADFFacetUtils.AdjustDeploymentAssemblyOperation {
        private IProject adfWebProject;

        public AdjustDeploymentAssemblyOperation(IProject webProject) {
            this.adfWebProject = webProject;
        }

        public void dispose() {
            this.adfWebProject = null;
            super.dispose();
        }

        @Override
        protected void computeWebAndReferencedProjects(Collection<IProject> adfWebProjects, Collection<IProject> referencedProjects, IProgressMonitor monitor) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            adfWebProjects.add(this.adfWebProject);
            List<IProject> allProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
            Map<String, List<IProject>> map = ADFFacetUtils.findProjectsWithFacets(allProjects, "oracle.adf.ear");
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)4);
            if (!map.isEmpty()) {
                List<IProject> adfEARProjects = map.get("oracle.adf.ear");
                for (IProject adfEARProject : adfEARProjects) {
                    List<IProject> aux;
                    Set projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)adfEARProject);
                    map = ADFFacetUtils.findProjectsWithFacets(projects, "jst.web", "jst.ejb", "jpt.jpa");
                    if (map.isEmpty() || (aux = map.get("jst.web")) == null || !aux.contains(this.adfWebProject)) continue;
                    aux = map.get("jst.ejb");
                    if (aux != null) {
                        referencedProjects.addAll(aux);
                    }
                    if ((aux = map.get("jpt.jpa")) == null) continue;
                    referencedProjects.addAll(aux);
                }
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String compoundOperationTitle;
        public static String webXmlConfigOperation;
        public static String addingADFDomainSharedLib;

        static {
            Strings.initializeMessages((String)ADFWebFacetInstallDelegate.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

