/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.RuntimeComponentProvider;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class ADFRuntimeComponentProvider
extends RuntimeComponentProvider {
    public static final String ADF_RUNTIME_COMPONENT_TYPE_ID = "oracle.weblogic.adf";
    private Map<File, String> versions = new HashMap<File, String>();
    private static final String WLS_HOME_PROP_KEY = "wls.home";

    public List<IRuntimeComponent> getRuntimeComponents(WebLogicServerInstall install) {
        String version;
        IRuntimeComponentType type;
        if (install.getVersion().compareTo((Enum)WebLogicServerVersion.VERSION_10_3_4) >= 0 && (type = RuntimeManager.getRuntimeComponentType((String)ADF_RUNTIME_COMPONENT_TYPE_ID)) != null && (version = this.getVersion(install)) != null) {
            String implVer = JRFRuntimeUtil.getJRFRuntimeImplVersion((File)install.getLocation());
            if (!implVer.startsWith(version)) {
                version = implVer;
            }
            IRuntimeComponentVersion rcv = type.getVersion(version);
            HashMap<String, String> properties = new HashMap<String, String>();
            ArrayList<IRuntimeComponent> ret = new ArrayList<IRuntimeComponent>(1);
            properties.put(WLS_HOME_PROP_KEY, install.getLocation().getAbsolutePath());
            IRuntimeComponent e = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties);
            ret.add(e);
            return ret;
        }
        return Collections.emptyList();
    }

    private String getVersion(WebLogicServerInstall install) {
        String cachedVersion = this.versions.get(install.getLocation());
        if (cachedVersion == null) {
            cachedVersion = JRFRuntimeUtil.getJRFRuntimeVersion((File)install.getLocation());
            this.versions.put(install.getLocation(), cachedVersion);
        }
        return cachedVersion;
    }
}

