/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperationConfigurator;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationConfiguratorLoader;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.operations.UninstallFacetLibrariesOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationLifecycleListenerDefinition;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IXmlProcessingConfiguration;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ADFEarFacetUninstallDelegate
implements IDelegate {
    private static final String CONFIGURATOR_EXTENSION_ID = "oracle.eclipse.tools.adf.view.configurator";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
        try {
            try {
                CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
                compoundOperation.add((IOperation)new UninstallFacetLibrariesOperation((LibraryFacetUninstallConfig)config));
                compoundOperation.add((IOperation)new UpdateApplicationXmlOperation(project));
                String CONTENT_FOLDER = OperationUtil.getContentFolderName((IProject)project);
                compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(CONTENT_FOLDER) + "/APP-INF/lib/adf-loc.jar"));
                compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(CONTENT_FOLDER) + "/adf/META-INF/adf-config.xml"));
                ICompoundOperationConfigurator configurator = new OperationConfiguratorLoader(CONFIGURATOR_EXTENSION_ID).getConfiguratorObject();
                ICompoundOperation configuredCompoundOperation = configurator.configure((ICompoundOperation)compoundOperation);
                IStatus operationStatus = configuredCompoundOperation.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100), null);
                if (operationStatus.getSeverity() != 0) {
                    LoggingService.logError((String)"oracle.eclipse.tools.adf.view", (String)("Compound configuration operation had one or more failures. " + operationStatus.getMessage()));
                }
            }
            catch (ExecutionException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "One or more ADF EAR facet uninstall operations failed.", (Throwable)e));
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String compoundOperationTitle;
        public static String updateWeblogicApplicationConfigurationLabel;

        static {
            Strings.initializeMessages((String)ADFEarFacetUninstallDelegate.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }

    private class UpdateApplicationXmlOperation
    extends AbstractBasicOperation {
        private final IProject project;

        public UpdateApplicationXmlOperation(IProject project) {
            super(Strings.updateWeblogicApplicationConfigurationLabel);
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
            try {
                IWebLogicAppDescriptor desc = WebLogicDescriptorFactory.getAppDescriptor((IProject)this.project);
                IXmlProcessingConfiguration xmlConfig = desc.getXmlProcessingConfiguration();
                if (((String)xmlConfig.getSaxParserFactory().content()).equals("oracle.xml.jaxp.JXSAXParserFactory")) {
                    xmlConfig.setSaxParserFactory(null);
                }
                if (((String)xmlConfig.getDocumentBuilderFactory().content()).equals("oracle.xml.jaxp.JXDocumentBuilderFactory")) {
                    xmlConfig.setDocumentBuilderFactory(null);
                }
                if (((String)xmlConfig.getTransformerFactory().content()).equals("oracle.xml.jaxp.JXSAXTransformerFactory")) {
                    xmlConfig.setTransformerFactory(null);
                }
                this.removeLifecycleListenerIfNecessary(desc, "oracle.adf.share.weblogic.listeners.ADFApplicationLifecycleListener");
                this.removeLifecycleListenerIfNecessary(desc, "oracle.mds.lcm.weblogic.WLLifecycleListener");
                this.removeSharedLibReferenceIfNecessary(desc, "adf.oracle.domain");
                desc.resource().save();
                desc.dispose();
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                Status status = new Status(0, "oracle.eclipse.tools.adf.view", "Successfully updated weblogic application configuration");
                return status;
            }
            catch (ResourceStoreException e) {
                throw new ExecutionException("Failed to update weblogic application configuration.", (Throwable)e);
            }
            finally {
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }

        private void removeSharedLibReferenceIfNecessary(IWebLogicAppDescriptor desc, String libraryName) {
            ILibraryRef ref = desc.getLibraryRef(libraryName);
            if (ref != null) {
                desc.getLibraryRefs().remove((Object)ref);
            }
        }

        private void removeLifecycleListenerIfNecessary(IWebLogicAppDescriptor desc, String listenerClass) {
            for (IApplicationLifecycleListenerDefinition listener : desc.getLifecycleListeners()) {
                if (listener.getClassName() == null || listener.getClassName().content() == null || !((String)listener.getClassName().content()).equals(listenerClass)) continue;
                desc.getLifecycleListeners().remove((Object)listener);
                break;
            }
        }
    }
}

