/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.ADFEarFacetUtils;
import oracle.eclipse.tools.adf.view.internal.ADFFacetUtils;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CopyFileOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.InstallFacetLibrariesOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.StringInputStream;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationLifecycleListenerDefinition;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IXmlProcessingConfiguration;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;

public class ADFEarFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)100);
        try {
            try {
                CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
                compoundOperation.add((IOperation)new InstallFacetLibrariesOperation(project, (LibraryFacetInstallConfig)config));
                if (ADFEarFacetInstallDelegate.isPrimaryRuntimeWLS(config)) {
                    compoundOperation.add((IOperation)new UpdateApplicationXmlOperation(project));
                }
                String CONTENT_FOLDER = OperationUtil.getContentFolderName((IProject)project);
                compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/adf-loc.jar", (IContainer)project, String.valueOf(CONTENT_FOLDER) + "/lib", false));
                compoundOperation.add((IOperation)new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/adf-config.xml", (IContainer)project, String.valueOf(CONTENT_FOLDER) + "/adf/META-INF", false));
                compoundOperation.add((IOperation)new SetADFAppUIDOperation(project, String.valueOf(CONTENT_FOLDER) + "/adf/META-INF/adf-config.xml"));
                compoundOperation.add((IOperation)new AdjustWebDeploymentAssemblyOperation(project));
                IStatus operationStatus = compoundOperation.execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100), null);
                if (operationStatus.getSeverity() != 0) {
                    LoggingService.logError((String)"oracle.eclipse.tools.adf.view", (String)("ADF EAR facet compound configuration operation had one or more failures. " + operationStatus.getMessage()));
                }
            }
            catch (ExecutionException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "One or more ADF EAR facet install operations failed.", (Throwable)e));
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static boolean isPrimaryRuntimeWLS(Object config) {
        List components;
        IRuntime runtime;
        IFacetedProjectWorkingCopy fpwc;
        boolean isWLS = false;
        if (config instanceof ActionConfig && (fpwc = ((ActionConfig)config).getFacetedProjectWorkingCopy()) != null && (runtime = fpwc.getPrimaryRuntime()) != null && (components = runtime.getRuntimeComponents()) != null) {
            for (IRuntimeComponent component : components) {
                IRuntimeComponentType type = component.getRuntimeComponentType();
                if (type == null || !type.getId().equals("com.bea.weblogic")) continue;
                isWLS = true;
                break;
            }
        }
        return isWLS;
    }

    private static final class AdjustWebDeploymentAssemblyOperation
    extends ADFFacetUtils.AdjustDeploymentAssemblyOperation {
        private IProject adfEARProject;

        public AdjustWebDeploymentAssemblyOperation(IProject adfEARProject) {
            this.adfEARProject = adfEARProject;
        }

        public void dispose() {
            this.adfEARProject = null;
            super.dispose();
        }

        @Override
        protected void computeWebAndReferencedProjects(Collection<IProject> adfWebProjects, Collection<IProject> referencedProjects, IProgressMonitor monitor) {
            List<IProject> aux;
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            Set projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)this.adfEARProject);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)6);
            Map<String, List<IProject>> map = ADFFacetUtils.findProjectsWithFacets(projects, "oracle.adf.web", "jst.ejb", "jpt.jpa");
            if (!map.isEmpty() && (aux = map.get("oracle.adf.web")) != null) {
                adfWebProjects.addAll(aux);
                aux = map.get("jst.ejb");
                if (aux != null) {
                    referencedProjects.addAll(aux);
                }
                if ((aux = map.get("jpt.jpa")) != null) {
                    referencedProjects.addAll(aux);
                }
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static class SetADFAppUIDOperation
    extends AbstractBasicOperation {
        private static final String ADF_APP_IDENTIFIER = "adfAppIdentifier";
        private IFile file = null;

        public SetADFAppUIDOperation(IProject project, String filename) {
            super(Strings.setADFAppUIDOperationLabel);
            if (project != null && filename != null && filename.length() > 0) {
                this.file = project.getFile(filename);
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            block8: {
                ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
                if (this.file != null && this.file.isAccessible()) {
                    try {
                        try {
                            InputStream in = this.file.getContents();
                            InputStreamReader reader = new InputStreamReader(in);
                            StringBuffer contents = new StringBuffer();
                            char[] buf = new char[1024];
                            int charsRead = 0;
                            while (charsRead > -1) {
                                charsRead = reader.read(buf);
                                if (charsRead <= 0) continue;
                                contents.append(buf, 0, charsRead);
                            }
                            String strContents = contents.toString();
                            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                            strContents = strContents.replace(ADF_APP_IDENTIFIER, this.getReplacementString());
                            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                            this.file.setContents((InputStream)new StringInputStream(strContents), false, false, monitor);
                            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                            break block8;
                        }
                        catch (CoreException cex) {
                            throw new ExecutionException("Failed to set adfAppUID property", (Throwable)cex);
                        }
                        catch (IOException ioex) {
                            throw new ExecutionException("Failed to set adfAppUID property", (Throwable)ioex);
                        }
                    }
                    finally {
                        ProgressMonitorUtil.done((IProgressMonitor)monitor);
                    }
                }
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return new Status(0, "oracle.eclipse.tools.adf.view", "Cannot set adfAppUID: ADF config file is not accessible");
            }
            return new Status(0, "oracle.eclipse.tools.adf.view", "Successfully set adfAppUID property");
        }

        private String getReplacementString() {
            IProject project;
            String ret = ADF_APP_IDENTIFIER;
            if (this.file != null && (project = this.file.getProject()) != null) {
                ret = project.getName();
            }
            return ret;
        }
    }

    private static final class Strings
    extends NLS {
        public static String compoundOperationTitle;
        public static String updateWeblogicApplicationConfigurationLabel;
        public static String setADFAppUIDOperationLabel;

        static {
            Strings.initializeMessages((String)ADFEarFacetInstallDelegate.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }

    private static class UpdateApplicationXmlOperation
    extends AbstractBasicOperation {
        private final IProject project;

        public UpdateApplicationXmlOperation(IProject project) {
            super(Strings.updateWeblogicApplicationConfigurationLabel);
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
            try {
                try {
                    IPath earContentPath = ADFFacetUtils.getContentPath(this.project);
                    IPath workspaceRootPath = this.project.getWorkspace().getRoot().getLocation();
                    if (earContentPath != null) {
                        // empty if block
                    }
                    String weblogic_app_xmlDest = workspaceRootPath.append(ADFEarFacetUtils.getWeblogicAppXmlPath(this.project)).toOSString();
                    File weblogic_app_xml = new File(weblogic_app_xmlDest);
                    this.updateWeblogicAppXML(weblogic_app_xml, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                }
                catch (ResourceStoreException e) {
                    throw new ExecutionException("Failed to update weblogic application configuration", (Throwable)e);
                }
            }
            finally {
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
            return new Status(0, "oracle.eclipse.tools.adf.view", "Successfully updated application.xml");
        }

        private void updateWeblogicAppXML(File file, IProgressMonitor monitor) throws ResourceStoreException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
            try {
                IWebLogicAppDescriptor desc = WebLogicDescriptorFactory.getAppDescriptor((IProject)this.project);
                IXmlProcessingConfiguration xmlConfig = desc.getXmlProcessingConfiguration();
                xmlConfig.setSaxParserFactory("oracle.xml.jaxp.JXSAXParserFactory");
                xmlConfig.setDocumentBuilderFactory("oracle.xml.jaxp.JXDocumentBuilderFactory");
                xmlConfig.setTransformerFactory("oracle.xml.jaxp.JXSAXTransformerFactory");
                this.addLifecycleListenerIfNecessary(desc, "oracle.adf.share.weblogic.listeners.ADFApplicationLifecycleListener");
                this.addLifecycleListenerIfNecessary(desc, "oracle.mds.lcm.weblogic.WLLifecycleListener");
                this.addSharedLibReference(desc, "adf.oracle.domain");
                desc.resource().save();
                desc.dispose();
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            finally {
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }

        private void addSharedLibReference(IWebLogicAppDescriptor desc, String libraryName) {
            ILibraryRef ref = desc.getLibraryRef(libraryName);
            if (ref == null) {
                ref = (ILibraryRef)desc.getLibraryRefs().insert();
                ref.setLibraryName(libraryName);
            }
        }

        private void addLifecycleListenerIfNecessary(IWebLogicAppDescriptor desc, String listenerClass) {
            boolean found = false;
            for (IApplicationLifecycleListenerDefinition listener : desc.getLifecycleListeners()) {
                if (listener.getClassName() == null || listener.getClassName().content() == null || !((String)listener.getClassName().content()).equals(listenerClass)) continue;
                found = true;
                break;
            }
            if (!found) {
                IApplicationLifecycleListenerDefinition listener;
                listener = (IApplicationLifecycleListenerDefinition)desc.getLifecycleListeners().insert();
                listener.setClassName(listenerClass);
            }
        }
    }
}

