/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.glassfish;

import java.io.File;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.project.facet.core.libprov.user.KeyClassesValidator;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AdfEssentailsUserLibValidator
extends KeyClassesValidator {
    private static final Object ADF_CONTROLLER_JAR = "adf-controller.jar";

    public IStatus validate(UserLibraryProviderInstallOperationConfig config) {
        String majorMinotVer;
        IProjectFacetVersion requiredVersion;
        String facetVersion;
        IStatus ret = super.validate(config);
        if (ret.getSeverity() != 0) {
            return ret;
        }
        String adfVersion = null;
        File adfControllerJar = null;
        try {
            for (IClasspathEntry cpe : config.resolve()) {
                File file;
                if (cpe.getEntryKind() != 1 || !(file = cpe.getPath().toFile()).exists() || !file.getName().equals(ADF_CONTROLLER_JAR)) continue;
                adfControllerJar = file;
                adfVersion = ADFGlassfishUtil.getOracleVersion((File)file);
                break;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (adfControllerJar == null) {
            String message = Strings.invalidLibrary;
            return new Status(4, "oracle.eclipse.tools.adf.view", message);
        }
        if (adfVersion != null && !(facetVersion = (requiredVersion = config.getProjectFacetVersion()).getVersionString()).startsWith(majorMinotVer = ADFGlassfishUtil.getMajorAndMinorVersion(adfVersion))) {
            String msg = Strings.versionMismatch;
            String message = NLS.bind((String)msg, adfVersion, (Object)facetVersion);
            return new Status(4, "oracle.eclipse.tools.adf.view", message);
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String versionMismatch;
        public static String invalidLibrary;

        static {
            Strings.initializeMessages((String)AdfEssentailsUserLibValidator.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

