/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.glassfish;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;

public class ADFRuntimeComponentProviderDelegate
extends RuntimeFacetComponentProviderDelegate {
    private Map<IRuntime, String> cached = Collections.synchronizedMap(new HashMap());

    public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        IRuntimeComponentType type;
        if (runtime.getRuntimeType().getId().startsWith("org.glassfish.jst.server.runtime.glassfish") && (type = RuntimeManager.getRuntimeComponentType((String)"oracle.glassfish.adf")) != null) {
            String cachedVersion = this.cached.get(runtime);
            if (cachedVersion != null) {
                return this.createRuntimeComponents(runtime, type, cachedVersion);
            }
            String adfVersion = null;
            adfVersion = "11.1.1";
            File domainPath = new File(runtime.getLocation().toFile(), "domains");
            File[] fileArray = domainPath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String jarVersion;
                File adfJar;
                File f = fileArray[n2];
                if (f.isDirectory() && (adfJar = new File(f + "/lib/adf-share-security.jar")).exists() && (jarVersion = ADFGlassfishUtil.getInstalledADFVersion((File)f)) != null && jarVersion.startsWith("12.1")) {
                    adfVersion = "12.1.2";
                }
                ++n2;
            }
            if (adfVersion != null) {
                this.cached.put(runtime, adfVersion);
                return this.createRuntimeComponents(runtime, type, adfVersion);
            }
        }
        return Collections.emptyList();
    }

    private List<IRuntimeComponent> createRuntimeComponents(IRuntime runtime, IRuntimeComponentType type, String adfVersion) {
        ArrayList<IRuntimeComponent> ret = new ArrayList<IRuntimeComponent>(1);
        IRuntimeComponentVersion rcv = type.getVersion(adfVersion);
        HashMap properties = new HashMap();
        IRuntimeComponent e = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties);
        ret.add(e);
        return ret;
    }
}

