/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseArtifactRef;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseOutcomeArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifactRef;
import oracle.eclipse.tools.adf.view.dependency.collection.ArtifactBasedAdfcActionNavCaseMatcher;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.javawebapp.resource.WebRootUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.CoreFaceletTagCollector;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ADFRichFacesJSFTagCollector
extends CoreFaceletTagCollector {
    static final String ID = "ADFRichFacesJSFTagCollector";
    private static final String NO_NAME = "<no-name-specified>";
    private static final Set<SubTypes> ALL_INTERESTING_TYPES;
    private static final Set<String> supportedUris;

    static {
        LinkedHashSet<SubTypes> types = new LinkedHashSet<SubTypes>(2, 1.0f);
        types.add(SubTypes.ADF_ACTION_SUBTYPE);
        types.add(SubTypes.ADF_URI_SUBTYPE);
        ALL_INTERESTING_TYPES = Collections.unmodifiableSet(types);
        HashSet<String> uris = new HashSet<String>();
        uris.add("http://xmlns.oracle.com/adf/faces/rich");
        uris.add("http://xmlns.oracle.com/dss/adf/faces");
        supportedUris = Collections.unmodifiableSet(uris);
    }

    public ADFRichFacesJSFTagCollector() {
        super(ID);
    }

    public void collect(CollectionContext context, IFile file, String uri, String name, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange ownerRange) {
        block5: {
            block6: {
                ResourceArtifact fileArtifact = context.ensureResourceArtifact((IResource)file);
                IXMLMetadataContext mdContext = this.getMdContext(file);
                EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getFeature(file, uri, name, attr.getName());
                if (fileArtifact == null || mdContext == null || feature == null) break block5;
                SubTypes subType = TleiAccess.INSTANCE.getSubtype(mdContext, feature);
                if (!ALL_INTERESTING_TYPES.contains(subType)) break block6;
                switch (subType) {
                    case ADF_URI_SUBTYPE: {
                        this.handleUriSubtype(context, mdContext, feature, attr, fileArtifact, file);
                        break;
                    }
                    case ADF_ACTION_SUBTYPE: {
                        if (!this.collectAdfcOutcome(context, attr.getAttr().getValue(), file, fileArtifact, attr)) {
                            this.collectAction(context, attr.getAttr().getValue(), file, fileArtifact, attr);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block5;
            }
            super.collect(context, file, uri, name, attr, ownerRange);
        }
    }

    private boolean collectAdfcOutcome(CollectionContext context, String action, IFile file, ResourceArtifact fileArtifact, DesignTimeContextData.AttributeRange actionAttr) {
        ControlFlowCaseOutcomeArtifact navCase;
        ResourceLocation location = this.createLocation(file, actionAttr);
        String fromOutcome = actionAttr.getELRanges().isEmpty() ? action : null;
        String fromViewID = WebRootUtil.getRuntimePath((IFile)file);
        ArtifactBasedAdfcActionNavCaseMatcher actionNavCaseMatcher = new ArtifactBasedAdfcActionNavCaseMatcher(context, file, fromViewID);
        Set outcomes = ADFRichFacesJSFTagCollector.getActionOutcomes((IFile)file, (DesignTimeContextData.AttributeRange)actionAttr);
        if (outcomes.isEmpty() && (navCase = actionNavCaseMatcher.matchOutcome(action, fromOutcome, location)) != null) {
            ControlFlowRuleArtifact navRule = (ControlFlowRuleArtifact)navCase.getOwner();
            this.addNavRuleReference(context, file, fileArtifact, location, navRule, (IFile)navCase.getLocation().getResource());
            this.addNavCaseReference(context, file, fileArtifact, location, navCase, navRule);
            return true;
        }
        return false;
    }

    private void addNavRuleReference(CollectionContext context, IFile file, ResourceArtifact fileArtifact, ResourceLocation location, ControlFlowRuleArtifact navRule, IFile referringResource) {
        String navRuleName = this.getNavigationRuleName(navRule);
        ControlFlowRuleArtifactRef ruleRef = new ControlFlowRuleArtifactRef(navRuleName, new ControlFlowRuleArtifactLocator(file, referringResource, navRule), (IArtifact)fileArtifact, location, this.getID());
        context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ruleRef, true, (byte)0);
    }

    private void addNavCaseReference(CollectionContext context, IFile file, ResourceArtifact fileArtifact, ResourceLocation location, ControlFlowCaseOutcomeArtifact navCase, ControlFlowRuleArtifact navRule) {
        String navCaseName = this.getNavigationCaseName(navCase);
        String navRuleName = navRule.getName();
        ControlFlowCaseArtifactRef caseRef = new ControlFlowCaseArtifactRef(navRuleName, navCaseName, navCase.getOutcome() == null ? null : navCase.getOutcome(), new ControlFlowCaseArtifactLocator(navRuleName, navCaseName, file, (IFile)navCase.getLocation().getResource()), (IArtifact)fileArtifact, location, this.getID());
        context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)caseRef, true, (byte)0);
    }

    private String getNavigationRuleName(ControlFlowRuleArtifact navRule) {
        String navRuleName = navRule.getName() == null ? "*" : navRule.getName();
        return navRuleName == null || navRuleName.equals("") ? "*" : navRuleName;
    }

    private String getNavigationCaseName(ControlFlowCaseOutcomeArtifact navCase) {
        String fromOutcome;
        String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
        if (fromOutcome == null) {
            return NO_NAME;
        }
        return fromOutcome;
    }

    public boolean supportsCollection(String uri, String name, String attrName) {
        return supportedUris.contains(uri);
    }
}

