/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFControllerArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlUsageIdArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlUsageIdArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefBindingArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefTaskflowArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFPageDefinitionArtifact;
import oracle.eclipse.tools.adf.view.dependency.collection.ADFControllerArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.collection.AdfCollectionHelper;
import oracle.eclipse.tools.application.common.services.collection.AbstractXpathCollector;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFMPageDefinitionCollector
extends AbstractXpathCollector {
    private static final String ADF_PAGE_DEF_NAMESPACE = "http://xmlns.oracle.com/adfm/uimodel";
    public static final String ID = "adfm.pagedef";
    private Map<String, IArtifact> iteratorIdToArtifactMap = new HashMap<String, IArtifact>();

    protected boolean collectDerivedResources() {
        return false;
    }

    protected void collectDocument(IDOMDocument document) {
        NodeList searchRegions;
        Assert.isLegal((document != null ? 1 : 0) != 0, (String)"Document must not be null");
        Assert.isNotNull((Object)this.getCollectionContext(), (String)"Collection context is null");
        Assert.isNotNull((Object)this.getResourceContext(), (String)"Resource context is null");
        IFile adfmPageDefFile = (IFile)this.getResourceContext().getResource();
        IPath pdPath = adfmPageDefFile.getProjectRelativePath().removeFirstSegments(1).removeFileExtension();
        String name = pdPath.toString().replace('/', '.');
        ResourceLocation loc = new ResourceLocation((IResource)adfmPageDefFile, null);
        ADFPageDefinitionArtifact pageDefArtifact = new ADFPageDefinitionArtifact(name, (IArtifact)this.getCollectionContext().ensureResourceArtifact((IResource)adfmPageDefFile), loc, loc, ID);
        this.getCollectionContext().addArtifact((IArtifact)pageDefArtifact, ID);
        NodeList taskFlowNodes = this.getNodes((IDOMNode)document, "//ns:executables/ns2:taskFlow");
        if (taskFlowNodes != null) {
            int i = 0;
            while (i < taskFlowNodes.getLength()) {
                String id;
                IDOMElement taskFlowElem;
                Attr idAttrNode;
                if (taskFlowNodes.item(i) instanceof IDOMElement && (idAttrNode = (taskFlowElem = (IDOMElement)taskFlowNodes.item(i)).getAttributeNode("id")) instanceof IDOMAttr && !(id = ((IDOMAttr)idAttrNode).getValue()).isEmpty()) {
                    ResourceLocation idLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)idAttrNode);
                    ADFMPageDefTaskflowArtifact taskFlowArtifact = new ADFMPageDefTaskflowArtifact(id, (IArtifact)pageDefArtifact, idLoc, idLoc, ID);
                    this.getCollectionContext().addArtifact((IArtifact)taskFlowArtifact, ID);
                    Attr taskFlowIdAttrNode = taskFlowElem.getAttributeNode("taskFlowId");
                    if (taskFlowIdAttrNode instanceof IDOMAttr) {
                        this.collectTaskFlowReference((IArtifact)pageDefArtifact, adfmPageDefFile, (IDOMAttr)taskFlowIdAttrNode, id);
                    }
                }
                ++i;
            }
        }
        if ((searchRegions = this.getNodes((IDOMNode)document, "//ns:executables/ns:searchRegion")) != null) {
            int i = 0;
            while (i < searchRegions.getLength()) {
                String id;
                IDOMElement searchRegionElem;
                Attr idAttrNode;
                if (searchRegions.item(i) instanceof IDOMElement && (idAttrNode = (searchRegionElem = (IDOMElement)searchRegions.item(i)).getAttributeNode("id")) instanceof IDOMAttr && !(id = ((IDOMAttr)idAttrNode).getValue()).isEmpty()) {
                    ResourceLocation idLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)idAttrNode);
                    ADFMPageDefSearchRegionArtifact searchRegionArtifact = new ADFMPageDefSearchRegionArtifact(id, (IArtifact)pageDefArtifact, idLoc, idLoc, ID);
                    this.getCollectionContext().addArtifact((IArtifact)searchRegionArtifact, ID);
                }
                ++i;
            }
        }
        this.collectIterators(document, pageDefArtifact, adfmPageDefFile);
        this.collectAllBindings(document, pageDefArtifact, adfmPageDefFile);
    }

    private void collectIterators(IDOMDocument document, ADFPageDefinitionArtifact pageDefnArtifact, IFile adfmPageDefFile) {
        NodeList execs = this.getNodes((IDOMNode)document, "//ns:executables");
        if (execs == null || execs.getLength() == 0) {
            return;
        }
        NodeList childNodes = execs.item(0).getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        int i = 0;
        int len = childNodes.getLength();
        while (i < len) {
            IDOMAttr idAttr;
            IDOMElement iterElem;
            String elemName;
            Node childNode = childNodes.item(i);
            if (childNode instanceof IDOMElement && (elemName = (iterElem = (IDOMElement)childNode).getLocalName()) != null && elemName.toLowerCase().endsWith("iterator") && (idAttr = (IDOMAttr)iterElem.getAttributeNode("id")) != null) {
                String id = idAttr.getValue();
                ResourceLocation loc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)idAttr);
                ADFMPageDefIteratorIdArtifact iteratorIdArtifact = new ADFMPageDefIteratorIdArtifact(id, (IArtifact)pageDefnArtifact, loc, loc, ID);
                this.getCollectionContext().addArtifact((IArtifact)iteratorIdArtifact, ID);
                this.iteratorIdToArtifactMap.put(id, (IArtifact)iteratorIdArtifact);
                IDOMAttr dataControlAttr = (IDOMAttr)iterElem.getAttributeNode("DataControl");
                if (dataControlAttr != null) {
                    ResourceLocation refLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)dataControlAttr);
                    String dataControlId = dataControlAttr.getValue();
                    ADFMDataControlUsageIdArtifactLocator locator = new ADFMDataControlUsageIdArtifactLocator(dataControlId, adfmPageDefFile.getProject());
                    ADFMDataControlUsageIdArtifactReference reference = new ADFMDataControlUsageIdArtifactReference(dataControlId, adfmPageDefFile.getProject(), locator, (IArtifact)iteratorIdArtifact, refLoc, ID);
                    this.getCollectionContext().addReferencedArtifact((IArtifact)iteratorIdArtifact, (IArtifactReference)reference, true, (byte)0);
                    IDOMAttr beanClassAttr = (IDOMAttr)iterElem.getAttributeNode("BeanClass");
                    if (beanClassAttr != null) {
                        this.addTypeReference((IArtifact)iteratorIdArtifact, adfmPageDefFile, beanClassAttr);
                    }
                }
            }
            ++i;
        }
    }

    private void addTypeReference(IArtifact referentArtifact, IFile adfmPageDefFile, IDOMAttr classAttr) {
        String className = classAttr.getValue();
        ResourceLocation classLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)classAttr);
        Set<IProject> projects = AdfCollectionHelper.getJavaProjectsBelongingToEar(adfmPageDefFile.getProject());
        if (projects != null) {
            boolean addRef = false;
            for (IProject p : projects) {
                IJavaProject javaProj = JavaCore.create((IProject)p);
                if (javaProj == null) continue;
                try {
                    IType type = javaProj.findType(className);
                    if (type == null) continue;
                    this.getCollectionContext().addTypeReference(referentArtifact, p, className, classLoc, false, ID);
                    addRef = true;
                    break;
                }
                catch (Exception exception) {}
            }
            if (!addRef) {
                this.getCollectionContext().addTypeReference(referentArtifact, adfmPageDefFile.getProject(), className, classLoc, false, ID);
            }
        }
    }

    private void collectAllBindings(IDOMDocument document, ADFPageDefinitionArtifact pageDefnArtifact, IFile adfmPageDefFile) {
        NodeList bindingsNL = this.getNodes((IDOMNode)document, "//ns:bindings");
        if (bindingsNL != null && bindingsNL.getLength() > 0) {
            NodeList bindingsChildNL = bindingsNL.item(0).getChildNodes();
            int i = 0;
            int len = bindingsChildNL.getLength();
            while (i < len) {
                IDOMElement attrValuesElem;
                IDOMAttr idAttr;
                Node bindingChild = bindingsChildNL.item(i);
                if (bindingChild instanceof IDOMElement && (idAttr = (IDOMAttr)(attrValuesElem = (IDOMElement)bindingChild).getAttributeNode("id")) != null) {
                    NodeList methodActionChildren;
                    int len1;
                    int j;
                    NodeList treeChildren;
                    ResourceLocation loc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)idAttr);
                    String id = idAttr.getValue();
                    ADFMPageDefBindingArtifact bindingArtifact = new ADFMPageDefBindingArtifact(id, (IArtifact)pageDefnArtifact, loc, loc, ID);
                    this.getCollectionContext().addArtifact((IArtifact)bindingArtifact, ID);
                    this.collectReferencetoIteratorId(document, (IArtifact)bindingArtifact, adfmPageDefFile, (IDOMElement)bindingsChildNL.item(i));
                    if (attrValuesElem.getLocalName().equals("tree") && (treeChildren = attrValuesElem.getChildNodes()) != null) {
                        j = 0;
                        len1 = treeChildren.getLength();
                        while (j < len1) {
                            IDOMAttr defAttr;
                            Node treeChild = treeChildren.item(j);
                            if (treeChild instanceof IDOMElement && treeChild.getLocalName().equals("nodeDefinition") && (defAttr = (IDOMAttr)((IDOMElement)treeChild).getAttributeNode("DefName")) != null) {
                                this.addTypeReference((IArtifact)bindingArtifact, adfmPageDefFile, defAttr);
                            }
                            ++j;
                        }
                    }
                    if (attrValuesElem.getLocalName().equals("methodAction") && (methodActionChildren = attrValuesElem.getChildNodes()) != null) {
                        j = 0;
                        len1 = methodActionChildren.getLength();
                        while (j < len1) {
                            IDOMAttr ndTypeAttr;
                            Node methodActionChild = methodActionChildren.item(j);
                            if (methodActionChild instanceof IDOMElement && methodActionChild.getLocalName().equals("NamedData") && (ndTypeAttr = (IDOMAttr)((IDOMElement)methodActionChild).getAttributeNode("NDType")) != null) {
                                this.addTypeReference((IArtifact)bindingArtifact, adfmPageDefFile, ndTypeAttr);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void collectReferencetoIteratorId(IDOMDocument document, IArtifact ownerArtifact, IFile adfmPageDefFile, IDOMElement domElement) {
        IDOMAttr iterBindingAttr = (IDOMAttr)domElement.getAttributeNode("IterBinding");
        if (iterBindingAttr != null) {
            String id = iterBindingAttr.getValue();
            ADFMPageDefIteratorIdArtifactLocator locator = new ADFMPageDefIteratorIdArtifactLocator(id, adfmPageDefFile);
            ResourceLocation refLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmPageDefFile, (IDOMNode)iterBindingAttr);
            ADFMPageDefIteratorIdArtifactReference activityReference = new ADFMPageDefIteratorIdArtifactReference(id, adfmPageDefFile, locator, ownerArtifact, refLoc, this.getID());
            this.getCollectionContext().addReferencedArtifact(ownerArtifact, (IArtifactReference)activityReference, false, (byte)0);
        }
    }

    private void collectTaskFlowReference(IArtifact pageDefArtifact, IFile pageDefFile, IDOMAttr taskFlowIdAttrNode, String id) {
        String taskFlowId = taskFlowIdAttrNode.getValue();
        if (!taskFlowId.isEmpty() && !taskFlowId.trim().startsWith("${")) {
            List<ValueReference> valueReferences = AdfCollectionHelper.collectReferenceToManagedBeanVariableAndType(pageDefArtifact, pageDefFile, this.getCollectionContext(), ID, (IDOMNode)taskFlowIdAttrNode, taskFlowId);
            if (valueReferences != null) {
                return;
            }
            ResourceLocation refLoc = this.getCollectionContext().getLocationOfNode((IResource)pageDefFile, (IDOMNode)taskFlowIdAttrNode);
            IProject project = this.getCollectionContext().getProject();
            ADFControllerArtifactLocator locator = new ADFControllerArtifactLocator(taskFlowId, project);
            ADFControllerArtifactReference reference = new ADFControllerArtifactReference(taskFlowId, id, project, locator, pageDefArtifact, refLoc, ID, true, false);
            this.getCollectionContext().addReferencedArtifact(pageDefArtifact, (IArtifactReference)reference, true, (byte)0);
        }
    }

    public String getID() {
        return ID;
    }

    protected NamespaceContext getNamespaceContext() {
        MapNamespaceContext nsc = new MapNamespaceContext("ns", ADF_PAGE_DEF_NAMESPACE);
        nsc.put("ns2", "http://xmlns.oracle.com/adf/controller/binding");
        return nsc;
    }

    protected Set<String> getDocumentContentTypes() {
        return Collections.singleton(DTRTContentType.PAGE_DEFINITION.getId());
    }
}

