/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMApplicationArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String pathName;
    private final IProject project;
    private volatile int hashCode = 0;

    public ADFMApplicationArtifactLocator(String pathName, IProject project) {
        this.pathName = pathName;
        this.project = project;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        StringBuilder path = new StringBuilder("adfmsrc/");
        path.append(this.pathName);
        IResource cpxFile = this.project.findMember(path.toString());
        if (cpxFile != null) {
            ResourceArtifact ra = model.ensureResourceArtifact(cpxFile);
            return model.queryArtifactsByOwnerNameAndType((IArtifact)ra, this.pathName, "adfm-application");
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMApplicationArtifactLocator) {
            boolean projectIsEqual;
            ADFMApplicationArtifactLocator otherLocator = (ADFMApplicationArtifactLocator)object;
            if (this.project != null) {
                projectIsEqual = this.project.equals((Object)otherLocator.project);
            } else {
                boolean bl = projectIsEqual = otherLocator.project == null;
            }
            if (projectIsEqual) {
                boolean tfIsEqual = this.pathName != null ? this.pathName.equals(otherLocator.pathName) : otherLocator.pathName == null;
                return tfIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.pathName);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.pathName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "pathName", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }
}

