/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.services.util.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ADFControllerArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String taskFlowId;
    private final IProject project;
    private volatile int hashCode = 0;

    public ADFControllerArtifactLocator(String taskFlowId, IProject project) {
        this.taskFlowId = taskFlowId;
        this.project = project;
    }

    private IResource getWebResource(String path) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.project);
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder().findMember(path);
        }
        return null;
    }

    public IArtifact locateArtifact() {
        List splitString = StringUtil.strToList((String)this.taskFlowId, (char)'#', (boolean)true);
        if (splitString.size() == 2) {
            String taskFlowPath = (String)splitString.get(0);
            IDependencyModel model = DependencyModelManager.getInstance().getModel();
            IResource tfFile = this.getWebResource(taskFlowPath);
            if (tfFile != null) {
                ResourceArtifact ra = model.ensureResourceArtifact(tfFile);
                return model.queryArtifactsByOwnerNameAndType((IArtifact)ra, this.taskFlowId, "adf-controller");
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ADFControllerArtifactLocator) {
            boolean projectIsEqual;
            ADFControllerArtifactLocator otherLocator = (ADFControllerArtifactLocator)object;
            if (this.project != null) {
                projectIsEqual = this.project.equals((Object)otherLocator.project);
            } else {
                boolean bl = projectIsEqual = otherLocator.project == null;
            }
            if (projectIsEqual) {
                boolean tfIsEqual = this.taskFlowId != null ? this.taskFlowId.equals(otherLocator.taskFlowId) : otherLocator.taskFlowId == null;
                return tfIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.taskFlowId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.taskFlowId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "taskFlowId", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }
}

