/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IResource;

public class AdfManagedBeanArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String mbName;
    private final IResource variableResource;
    private volatile int hashCode = 0;

    public AdfManagedBeanArtifactLocator(String mbName, IResource variableResource) {
        this.mbName = mbName;
        this.variableResource = variableResource;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        if (this.variableResource != null) {
            ResourceArtifact ra = model.ensureResourceArtifact(this.variableResource);
            Set ownedArtifacts = model.queryArtifactsByOwner((IArtifact)ra);
            AdfControllerArtifact ownerArtifact = null;
            if (ownedArtifacts != null && ownedArtifacts.size() > 0) {
                for (IArtifact ownedArtifact : ownedArtifacts) {
                    if (!(ownedArtifact instanceof AdfControllerArtifact)) continue;
                    ownerArtifact = (AdfControllerArtifact)ownedArtifact;
                    break;
                }
            }
            return model.queryArtifactsByOwnerNameAndType(ownerArtifact, this.mbName, "adf-managed-bean");
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof AdfManagedBeanArtifactLocator) {
            boolean resourceIsEqual;
            AdfManagedBeanArtifactLocator otherLocator = (AdfManagedBeanArtifactLocator)object;
            if (this.variableResource != null) {
                resourceIsEqual = this.variableResource.equals((Object)otherLocator.variableResource);
            } else {
                boolean bl = resourceIsEqual = otherLocator.variableResource == null;
            }
            if (resourceIsEqual) {
                boolean mbIsEqual = this.mbName != null ? this.mbName.equals(otherLocator.mbName) : otherLocator.mbName == null;
                return mbIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.variableResource);
            hcu.hash((Object)this.mbName);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mbName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource(this.variableResource);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "mbName", String.class);
        su.readFinalResourceFromStream((Object)this, "variableResource");
    }
}

