/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class AdfControllerArtifact
extends AbstractVirtualArtifact
implements Serializable {
    public static final String TYPE = "adf-controller";
    private static final String XML_EXTENSION = ".xml";
    private static final long serialVersionUID = 617820352270916901L;
    private final IArtifact owner;
    private final String name;
    private final boolean isTemplate;

    public AdfControllerArtifact(IArtifact owner, String name, ResourceLocation location, ResourceLocation boundedLocation, String collectorID, boolean isTemplate) {
        super(location, boundedLocation, collectorID);
        this.owner = owner;
        this.name = name;
        this.isTemplate = isTemplate;
    }

    public AdfControllerArtifact(IFile configFile, String collectorID, boolean isTemplate) {
        this((IArtifact)AdfControllerArtifact.toArtifact(configFile), AdfControllerArtifact.toName(configFile), collectorID, isTemplate);
    }

    private AdfControllerArtifact(IArtifact owner, String name, String collectorID, boolean isTemplate) {
        this(owner, name, owner.getLocation(), owner.getLocation(), collectorID, isTemplate);
    }

    public boolean isMissing() {
        return false;
    }

    public String getType() {
        return TYPE;
    }

    public String getName() {
        return this.name;
    }

    public IArtifact getOwner() {
        return this.owner;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    private static final ResourceArtifact toArtifact(IFile adfConigFile) {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        return model.ensureResourceArtifact((IResource)adfConigFile);
    }

    private static final String toName(IFile adfConfigFile) {
        String name = adfConfigFile.getName();
        if (name.endsWith(XML_EXTENSION)) {
            name = name.substring(0, name.length() - XML_EXTENSION.length());
        }
        return name;
    }
}

