/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class ADFMPageDefSearchRegionArtifactReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final String searchRegionId;
    private final IFile pageDefFile;

    public ADFMPageDefSearchRegionArtifactReference(String iteratorId, IFile pagedefFile, IArtifactLocator targetArtifactLocator, IArtifact owner, ResourceLocation location, String collectorID) {
        super(targetArtifactLocator, owner);
        this.searchRegionId = iteratorId;
        this.pageDefFile = pagedefFile;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    public String getName() {
        return this.searchRegionId;
    }

    public String getType() {
        return "adfm-pagedef-searchregion";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    protected IArtifact createMissingArtifact() {
        IFile resource = this.pageDefFile;
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)resource);
        return new MissingADFMPageDefSearchRegionArtifact(this.searchRegionId, (IArtifact)owner, new ResourceLocation((IResource)resource, null));
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMPageDefSearchRegionArtifactReference) {
            boolean bindingIdIsEqual;
            ADFMPageDefSearchRegionArtifactReference otherRef = (ADFMPageDefSearchRegionArtifactReference)((Object)object);
            if (this.searchRegionId != null) {
                bindingIdIsEqual = this.searchRegionId.equals(otherRef.searchRegionId);
            } else {
                boolean bl = bindingIdIsEqual = otherRef.searchRegionId == null;
            }
            if (bindingIdIsEqual) {
                boolean fileIsEqual;
                if (this.pageDefFile != null) {
                    fileIsEqual = this.pageDefFile.equals((Object)otherRef.pageDefFile);
                } else {
                    boolean bl = fileIsEqual = otherRef.pageDefFile == null;
                }
                return super.equals(object) && fileIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.searchRegionId);
            hcu.hash((Object)this.pageDefFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.searchRegionId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.pageDefFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "searchRegionId", String.class);
        su.readFinalResourceFromStream((Object)this, "pageDefFile");
    }

    private class MissingADFMPageDefSearchRegionArtifact
    extends ADFMPageDefSearchRegionArtifact {
        private static final long serialVersionUID = 1L;

        public MissingADFMPageDefSearchRegionArtifact(String id, IArtifact owner, ResourceLocation location) {
            super(id, owner, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

