/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.view.controller.ADFmDataControlConfigTypeFilter;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.collection.AdfCollectionHelper;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class ADFMAdapterDataControlArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String pathName;
    private final IProject project;
    private volatile int hashCode = 0;

    public ADFMAdapterDataControlArtifactLocator(String pathName, IProject project) {
        this.pathName = pathName;
        this.project = project;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        Set<IFile> dcxFiles = ADFMAdapterDataControlArtifactLocator.getMatchingDCXFiles(this.pathName, this.project);
        for (IFile dcxFile : dcxFiles) {
            IArtifact artifact2;
            ResourceArtifact ra = model.ensureResourceArtifact((IResource)dcxFile);
            Set childArtifacts = model.queryArtifactsByOwner((IArtifact)ra);
            ADFMDataControlArtifact dataControlArtifact = null;
            if (childArtifacts != null) {
                for (IArtifact artifact2 : childArtifacts) {
                    if (!(artifact2 instanceof ADFMDataControlArtifact)) continue;
                    dataControlArtifact = (ADFMDataControlArtifact)artifact2;
                    break;
                }
            }
            if (dataControlArtifact == null || (artifact2 = model.queryArtifactsByOwnerNameAndType(dataControlArtifact, this.pathName, "adf-datacontrol-adapter")) == null) continue;
            return artifact2;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMAdapterDataControlArtifactLocator) {
            boolean projectIsEqual;
            ADFMAdapterDataControlArtifactLocator otherLocator = (ADFMAdapterDataControlArtifactLocator)object;
            if (this.project != null) {
                projectIsEqual = this.project.equals((Object)otherLocator.project);
            } else {
                boolean bl = projectIsEqual = otherLocator.project == null;
            }
            if (projectIsEqual) {
                boolean tfIsEqual = this.pathName != null ? this.pathName.equals(otherLocator.pathName) : otherLocator.pathName == null;
                return tfIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.pathName);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.pathName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "pathName", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }

    static Set<IFile> getMatchingDCXFiles(String pathToDCId, IProject webProject) {
        HashSet<IFile> matchingDCXFiles = new HashSet<IFile>();
        Set<IProject> projects = AdfCollectionHelper.getJavaProjectsBelongingToEar(webProject);
        if (projects != null) {
            for (IProject project : projects) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject == null) continue;
                try {
                    IPackageFragmentRoot[] pkgFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    if (pkgFragmentRoots == null) continue;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = pkgFragmentRoots;
                    int n = pkgFragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource[] resources;
                        String pkg;
                        IFolder folder;
                        int index;
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        IResource res = root.getResource();
                        if (res instanceof IContainer && root.getResource().exists() && (index = pathToDCId.lastIndexOf(46)) != -1 && (folder = ((IContainer)res).getFolder((IPath)new Path((pkg = pathToDCId.substring(0, index)).replace('.', '/')))).exists() && (resources = folder.members()) != null) {
                            IResource[] iResourceArray = resources;
                            int n3 = resources.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource resource = iResourceArray[n4];
                                if (resource.getType() == 1 && ADFmDataControlConfigTypeFilter.getInstance().match(resource)) {
                                    matchingDCXFiles.add((IFile)resource);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return matchingDCXFiles;
    }
}

