/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.configuration.WebXmlExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.validator.AbstractAdfValidationDelegate;
import oracle.eclipse.tools.adf.view.configuration.validator.conditions.WebXMLConditionFactory;
import oracle.eclipse.tools.application.common.services.document.validator.CompositeValidate;
import oracle.eclipse.tools.application.common.services.document.validator.ConditionalValidate;
import oracle.eclipse.tools.application.common.services.document.validator.Validate;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateDependentBlock;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateDontHaveBlock;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateRequiredBlock;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogue;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import oracle.eclipse.tools.common.services.confvalidation.ProblemCatalogueInstance;
import oracle.eclipse.tools.common.services.confvalidation.ValidationContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;

public class WebXmlValidationDelegate
extends AbstractAdfValidationDelegate {
    private static final List<Validate> VALIDATORS;

    static {
        List<Validate> validates = Collections.EMPTY_LIST;
        if (Platform.getExtensionRegistry() != null) {
            validates = WebXmlValidationDelegate.createValidates(ProblemCatalogueInstance.getInstance(), new WebXMLConditionFactory());
        }
        VALIDATORS = Collections.unmodifiableList(validates);
    }

    protected static List<Validate> createValidates(ProblemCatalogue catalogue, WebXMLConditionFactory conditionFactory) {
        WebXmlExpressionBuilderFactory factory = new WebXmlExpressionBuilderFactory();
        ArrayList<Validate> validates = new ArrayList<Validate>();
        validates.add((Validate)new ValidateRequiredBlock(factory.createFacesServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFacesServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createResourceServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingResourceServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createTrinidadFilterPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingTrindadFilter")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createTrinidadCheckFileModContextParamPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingCheckFileModParam")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createADFServletFilterPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingServletADFFilter")), conditionFactory.getCondition("missingServletADFFilter")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createADFBindingsFilterPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingADFBindingFilter")), conditionFactory.getCondition("missingADFBindingFilter")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createFacesStateSavingContextParamPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFacesStateSavingParam")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createAdfVersionStringHiddenContextParamPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingAdfVersionStringHiddenParam")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createBIGraphServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingBIGraphServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createMapProxyServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingMapProxyServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createBIGaugeServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingBIGaugeServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createGatewayServletPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingGatewayServlet")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createJspJsffConfigPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingJSPPropertyJSFF")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createAdfConfigLifecycleCallbackListenerPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingADFConfigLifecycleCallBack")), conditionFactory.getCondition("missingADFConfigLifecycleCallBack")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateDontHaveBlock(factory.createAdfConfigLifecycleCallbackListenerPresent(), WebXmlValidationDelegate.getIndex(catalogue, "shouldNotUseADFConfigLifecycleCallBackWithGlassfish")), conditionFactory.getCondition("shouldNotUseADFConfigLifecycleCallBackWithGlassfish")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createAdfGlassfishAppLifecycleCallbackListenerPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingADFGlassfishAppConfigLifecycleCallBack")), conditionFactory.getCondition("missingADFGlassfishAppConfigLifecycleCallBack")));
        validates.add((Validate)new ValidateDependentBlock(factory.createResourceServletNamePresent(), factory.createAdfPathResourceMappingPresent(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingResourceServletMappingAdf")));
        validates.add((Validate)new ValidateDependentBlock(factory.createResourceServletNamePresent(), factory.createAdrPathResourceMappingPresent(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingResourceServletMappingAfr")));
        validates.add((Validate)new ValidateDependentBlock(factory.createResourceServletNamePresent(), factory.createBiPathResourceMappingPresent(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingResourceServletMappingBi")));
        validates.add((Validate)new ValidateDependentBlock(factory.createFacesServletNamePresent(), factory.createFacesServletMappingPresent2(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingFacesServletMapping")));
        validates.add((Validate)new ValidateDependentBlock(factory.createBIGraphServletNamePresent(), factory.createBIGraphServletMappingPresent2(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingBiGraphServletMapping")));
        validates.add((Validate)new ValidateDependentBlock(factory.createBIGaugeServletNamePresent(), factory.createBIGaugeServletMappingPresent2(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingBIGaugeServletMapping")));
        validates.add((Validate)new ValidateDependentBlock(factory.createMapProxyServletNamePresent(), factory.createMapProxyServletMappingPresent2(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingMapProxyServletMapping")));
        validates.add((Validate)new ValidateDependentBlock(factory.createGatewayServletNamePresent(), factory.createGatewayServletMappingPresent2(), "servlet-name", WebXmlValidationDelegate.getIndex(catalogue, "missingGatewayServletMapping")));
        validates.add((Validate)new ValidateDependentBlock(Arrays.asList(factory.createFacesServletNamePresent(), factory.createTrinidadFilterNamePresent()), factory.createFilterMappingPresentTwoArg(), Arrays.asList("servlet-name", "filter-name"), WebXmlValidationDelegate.getIndex(catalogue, "missingTrindadFilterMapping")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateDependentBlock(Arrays.asList(factory.createFacesServletNamePresent(), factory.createADFServletFilterPresent()), factory.createFilterMappingPresentTwoArg(), Arrays.asList("servlet-name", "filter-name"), WebXmlValidationDelegate.getIndex(catalogue, "missingServletADFFilterMapping")), conditionFactory.getCondition("missingServletADFFilterMapping")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateDependentBlock(Arrays.asList(factory.createFacesServletNamePresent(), factory.createADFBindingsFilterPresent()), factory.createFilterMappingPresentTwoArg(), Arrays.asList("servlet-name", "filter-name"), WebXmlValidationDelegate.getIndex(catalogue, "missingADFBindingFilterMapping")), conditionFactory.getCondition("missingADFBindingFilterMapping")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createJSFFaceletViewMappingsPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFaceletContextParamJSFFaceletViewMappings")), conditionFactory.getCondition("missingFaceletContextParamJSFFaceletViewMappings")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createJSFFaceletsSkipCommentsPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFaceletContextParamSkipComments")), conditionFactory.getCondition("missingFaceletContextParamSkipComments")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createADFFaceletTagDecoratorPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFaceletContextParamADFFaceletTagDecorator")), conditionFactory.getCondition("missingFaceletContextParamADFFaceletTagDecorator")));
        validates.add((Validate)new ConditionalValidate((Validate)new ValidateRequiredBlock(factory.createADFFaceletResourceResolverPresent(), WebXmlValidationDelegate.getIndex(catalogue, "missingFaceletContextParamADFFaceletResourceResolver")), conditionFactory.getCondition("missingFaceletContextParamADFFaceletResourceResolver")));
        return validates;
    }

    private static ProblemCatalogueIndex getIndex(ProblemCatalogue catalogue, String id) {
        return catalogue.getIndex("adfWebXml", id);
    }

    public WebXmlValidationDelegate() {
        this(new CompositeValidate(VALIDATORS), (AbstractVirtualComponentQuery)new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery(), new StructuredModelXMLDocumentProvider(StructuredModelXMLDocumentProvider.ModelRequestType.SHARED_READ));
    }

    public WebXmlValidationDelegate(CompositeValidate validate, AbstractVirtualComponentQuery vcQuery, StructuredModelXMLDocumentProvider provider) {
        super(validate, vcQuery, provider);
    }

    public WebXmlValidationDelegate(AbstractVirtualComponentQuery vcQuery, StructuredModelXMLDocumentProvider provider) {
        this(new CompositeValidate(VALIDATORS), vcQuery, provider);
    }

    public boolean isEnabled(ValidationContext context) {
        IResource resource = context.getResource();
        if (resource.getType() == 1 && context.isMinimumTechExtensionVersion("adf.web", "11.1.1")) {
            IFile file = (IFile)resource;
            return this.isWebXmlFile(file);
        }
        return false;
    }

    private boolean isWebXmlFile(IFile file) {
        return this.isInWebRoot(file, (IPath)new Path("WEB-INF/web.xml"));
    }
}

