/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.configuration.FacesConfigExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.validator.AbstractAdfValidationDelegate;
import oracle.eclipse.tools.application.common.services.document.validator.CompositeValidate;
import oracle.eclipse.tools.application.common.services.document.validator.Validate;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateRequiredBlock;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogue;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import oracle.eclipse.tools.common.services.confvalidation.ProblemCatalogueInstance;
import oracle.eclipse.tools.common.services.confvalidation.ValidationContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;

public class FacesConfigValidationDelegate
extends AbstractAdfValidationDelegate {
    private static final List<Validate> VALIDATORS;

    static {
        List<Validate> validates = Collections.EMPTY_LIST;
        if (Platform.getExtensionRegistry() != null) {
            validates = FacesConfigValidationDelegate.createValidates(ProblemCatalogueInstance.getInstance());
        }
        VALIDATORS = Collections.unmodifiableList(validates);
    }

    protected static List<Validate> createValidates(ProblemCatalogue catalogue) {
        FacesConfigExpressionBuilderFactory factory = new FacesConfigExpressionBuilderFactory();
        ArrayList<Validate> validates = new ArrayList<Validate>();
        validates.add((Validate)new ValidateRequiredBlock(factory.createDefaultRenderKitIdPresent(), FacesConfigValidationDelegate.getIndex(catalogue, "missingRichFacesDefaultRenderKit")));
        return validates;
    }

    private static ProblemCatalogueIndex getIndex(ProblemCatalogue catalogue, String id) {
        return catalogue.getIndex("adfFacesConfigXml", id);
    }

    public FacesConfigValidationDelegate() {
        super(new CompositeValidate(VALIDATORS));
    }

    public FacesConfigValidationDelegate(CompositeValidate compositeValidate, AbstractVirtualComponentQuery mockVirtualComponentQuery, StructuredModelXMLDocumentProvider provider) {
        super(compositeValidate, mockVirtualComponentQuery, provider);
    }

    public boolean isEnabled(ValidationContext context) {
        IResource resource = context.getResource();
        if (resource.getType() == 1 && context.isMinimumFacetInstalled("oracle.adf.web", "11.1.1")) {
            IFile file = (IFile)resource;
            return this.isFacesConfigFile(file);
        }
        return false;
    }

    private boolean isFacesConfigFile(IFile file) {
        return this.isInWebRoot(file, (IPath)new Path("WEB-INF/faces-config.xml"));
    }
}

