/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.configuration.IConfigurationStrategy;
import oracle.eclipse.tools.adf.view.configuration.WeblogicApplicationExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.template.VelocityTemplateContext;
import oracle.eclipse.tools.adf.view.configuration.template.WeblogicApplicationTemplateBean;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.MergePositionLocator;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.application.common.services.document.XPathRegionResolver;
import oracle.eclipse.tools.application.common.services.document.configuration.AbstractConfiguration;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariable;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariableResolver;
import oracle.eclipse.tools.application.common.services.document.variable.XPathPrefixVariableResolver;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class WeblogicApplicationConfiguration
extends AbstractConfiguration<WeblogicApplicationConfigType>
implements IConfigurationStrategy {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.adf.view.template.weblogic.application";
    private static String PREFIX_VARIABLE = "prefix";
    private static final WeblogicApplicationExpressionBuilderFactory exprFactory = new WeblogicApplicationExpressionBuilderFactory();

    public void performUpdate(WeblogicApplicationConfigType configType, XMerge merge) {
        try {
            TemplateContextType contextType = new TemplateContextType(configType.getId());
            contextType.addResolver((TemplateVariableResolver)new XPathExpressionVariableResolver());
            contextType.addResolver((TemplateVariableResolver)new XPathPrefixVariableResolver(PREFIX_VARIABLE));
            VelocityTemplateContext context = new VelocityTemplateContext(contextType, merge.getTargetDocument());
            String templateBuffer = context.evaluate(this.createTemplateVariables(configType), TEMPLATE_ID, this.createTemplateBean(context));
            if (context.isValid()) {
                merge.merge(templateBuffer, this.createMergePositionLocator(configType));
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (Throwable)e);
        }
    }

    public List<TemplateVariable> createTemplateVariables(WeblogicApplicationConfigType type) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        switch (type) {
            case ADF_DOMAIN_LIBRARY_REF: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createADFDomainLibRefPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
            case JSP_NEXT_LIBRARY_REF: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createJSPNextLibraryRefPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
            case XML_PARSER_FACTORY: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createXMLParserFactoryPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
            case XML_SAX_PARSER_FACTORY: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createJXSaxParserFactoryPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createXMLParserFactoryPresent()));
                return variables;
            }
            case XML_DOCUMENT_BUILDER_FACTORY: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createJXDocumentBuilderFactoryPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createXMLParserFactoryPresent()));
                return variables;
            }
            case XML_TRANFORMER_FACTORY: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createJXTransformerFactoryPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createXMLParserFactoryPresent()));
                return variables;
            }
            case JX_SAXPARSER_FACTORY: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createJXSaxParserFactoryPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
            case ADF_APPLICATION_LIFECYCLE_LISTENER: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createADFApplicationLifecycleListenerPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
            case WL_LIFECYCLE_LISTENER: {
                variables.add((TemplateVariable)this.createDefaultValidationVariable(exprFactory.createWLLifecycleListenerPresent()));
                variables.add((TemplateVariable)this.createPrefixVariable(exprFactory.createWeblogicApplicationRoot()));
                return variables;
            }
        }
        return variables;
    }

    private XPathExpressionVariable createPrefixVariable(ExpressionBuilder expressionBuilder) {
        XPathExpressionVariable xVariable = new XPathExpressionVariable(PREFIX_VARIABLE, PREFIX_VARIABLE, "", null);
        xVariable.addQualifiedXPathExpression(expressionBuilder);
        return xVariable;
    }

    public MergePositionLocator createMergePositionLocator(WeblogicApplicationConfigType type) {
        MergePositionLocator locator = new MergePositionLocator();
        switch (type) {
            case XML_SAX_PARSER_FACTORY: {
                locator.setDefaultParentExpression(exprFactory.createXMLParserFactoryPresent(), XPathRegionResolver.RegionType.START);
                return locator;
            }
            case XML_DOCUMENT_BUILDER_FACTORY: {
                locator.setDefaultParentExpression(exprFactory.createXMLParserFactoryPresent(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(exprFactory.createDocumentBuilderFactoryMerge(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case XML_TRANFORMER_FACTORY: {
                locator.setDefaultParentExpression(exprFactory.createXMLParserFactoryPresent(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case ADF_DOMAIN_LIBRARY_REF: 
            case JSP_NEXT_LIBRARY_REF: {
                locator.setDefaultParentExpression(exprFactory.createWeblogicApplicationRoot());
                locator.setOrderSiblingExpression(exprFactory.createLibraryRefMerge());
                return locator;
            }
            case XML_PARSER_FACTORY: 
            case JX_SAXPARSER_FACTORY: {
                locator.setDefaultParentExpression(exprFactory.createWeblogicApplicationRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(exprFactory.createXmlMerge(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case ADF_APPLICATION_LIFECYCLE_LISTENER: 
            case WL_LIFECYCLE_LISTENER: {
                locator.setDefaultParentExpression(exprFactory.createWeblogicApplicationRoot());
                locator.setOrderSiblingExpression(exprFactory.createListenerMerge());
                return locator;
            }
        }
        locator.setDefaultParentExpression(exprFactory.createWeblogicApplicationRoot());
        return locator;
    }

    @Override
    public ITemplateBean createTemplateBean(VelocityTemplateContext context) {
        return new WeblogicApplicationTemplateBean(context);
    }

    public static enum WeblogicApplicationConfigType {
        ADF_DOMAIN_LIBRARY_REF("aDFDomainLibraryRef"),
        JSP_NEXT_LIBRARY_REF("jspNextLibraryRef"),
        XML_PARSER_FACTORY("xmlParserFactory"),
        JX_SAXPARSER_FACTORY("jXSAXParserFactory"),
        ADF_APPLICATION_LIFECYCLE_LISTENER("aDFApplicationLifecycleListener"),
        WL_LIFECYCLE_LISTENER("wLLifecycleListener"),
        XML_SAX_PARSER_FACTORY("xmlSaxParserFactory"),
        XML_DOCUMENT_BUILDER_FACTORY("documentBuilderFactory"),
        XML_TRANFORMER_FACTORY("xmlTransformerFactory");

        private final String _id;

        private WeblogicApplicationConfigType(String id) {
            this._id = id;
        }

        public static WeblogicApplicationConfigType getVariableType(String id) {
            WeblogicApplicationConfigType[] weblogicApplicationConfigTypeArray = WeblogicApplicationConfigType.values();
            int n = weblogicApplicationConfigTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                WeblogicApplicationConfigType type = weblogicApplicationConfigTypeArray[n2];
                if (type.getId().equals(id)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getId() {
            return this._id;
        }
    }
}

