/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.configuration.FacesConfigExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.IConfigurationStrategy;
import oracle.eclipse.tools.adf.view.configuration.template.FacesTemplateBean;
import oracle.eclipse.tools.adf.view.configuration.template.VelocityTemplateContext;
import oracle.eclipse.tools.application.common.services.document.MergePositionLocator;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.application.common.services.document.configuration.AbstractConfiguration;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariable;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariableResolver;
import oracle.eclipse.tools.application.common.services.document.variable.XPathPrefixVariableResolver;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class FacesConfiguration
extends AbstractConfiguration<FacesConfigType>
implements IConfigurationStrategy {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.adf.view.template.faces.config";
    private static String PREFIX_VARIABLE = "prefix";
    private final FacesConfigExpressionBuilderFactory exprFactory = new FacesConfigExpressionBuilderFactory();

    public void performUpdate(FacesConfigType configType, XMerge merge) {
        try {
            TemplateContextType contextType = new TemplateContextType(configType.getId());
            contextType.addResolver((TemplateVariableResolver)new XPathExpressionVariableResolver());
            contextType.addResolver((TemplateVariableResolver)new XPathPrefixVariableResolver(PREFIX_VARIABLE));
            VelocityTemplateContext context = new VelocityTemplateContext(contextType, merge.getTargetDocument());
            String templateBuffer = context.evaluate(this.createTemplateVariables(configType), TEMPLATE_ID, this.createTemplateBean(context));
            if (context.isValid()) {
                MergePositionLocator locator = new MergePositionLocator();
                locator.setDefaultParentExpression(this.exprFactory.createFacesConfigRoot());
                merge.merge(templateBuffer, locator);
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (Throwable)e);
        }
    }

    public List<TemplateVariable> createTemplateVariables(FacesConfigType type) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        switch (type) {
            case DEFAULT_RENDER_KIT: {
                XPathExpressionVariable xVariable = this.createDefaultValidationVariable(this.exprFactory.createDefaultRenderKitIdPresent());
                variables.add((TemplateVariable)xVariable);
                xVariable = new XPathExpressionVariable(PREFIX_VARIABLE, PREFIX_VARIABLE, "", null);
                xVariable.addQualifiedXPathExpression(this.exprFactory.createFacesConfigRoot());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
        }
        return variables;
    }

    @Override
    public ITemplateBean createTemplateBean(VelocityTemplateContext context) {
        return new FacesTemplateBean(context);
    }

    public static enum FacesConfigType {
        DEFAULT_RENDER_KIT("defaultRenderKit");

        private final String _id;

        private FacesConfigType(String id) {
            this._id = id;
        }

        public static FacesConfigType getVariableType(String id) {
            FacesConfigType[] facesConfigTypeArray = FacesConfigType.values();
            int n = facesConfigTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FacesConfigType type = facesConfigTypeArray[n2];
                if (type.getId().equals(id)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getId() {
            return this._id;
        }
    }
}

