/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.ServiceDefinitionFactory;
import oracle.eclipse.tools.adf.view.appgen.utils.EntityUtil;
import oracle.eclipse.tools.adf.view.appgen.utils.TypeElement;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.env.EnvironmentFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JavaServiceUtil {
    private static final Pattern DT_ID_PATTERN = Pattern.compile(".*((?i)generated).*DT_ID=(.*)\\s*$");

    public static IType[] getTypes(IFile file) throws JavaModelException {
        IJavaElement elem = JavaCore.create((IFile)file);
        if (elem instanceof ICompilationUnit) {
            return ((ICompilationUnit)elem).getTypes();
        }
        return null;
    }

    public static IServiceDefinition reconstructServiceDefinition(IProject project, String classname) {
        if (project == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Invalid java service");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        IFile beanFile = JavaUtil.getExistingJavaFile((IProject)project, (String)classname);
        if (beanFile != null) {
            IServiceDefinition serviceDefn = ServiceDefinitionFactory.createServiceDefinition();
            serviceDefn.setJpaProjectName(beanFile.getProject().getName());
            for (String entityName : EntityUtil.getClassEntityNames(project, classname)) {
                serviceDefn.addEntityName(entityName);
            }
            return serviceDefn;
        }
        return null;
    }

    public static void reconstructDataModel(IProject project, String classname, IDataModel dataModel) {
        IJavaProject javaProject = JavaUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                AnnotationProcessorEnvironment ape;
                TypeDeclaration td;
                ICompilationUnit cu;
                IType type = javaProject.findType(classname);
                if (type != null && (cu = type.getCompilationUnit()) != null && (td = (ape = EnvironmentFactory.getEnvironment((ICompilationUnit)cu, (IJavaProject)javaProject)).getTypeDeclaration(classname)) != null) {
                    TypeElement te = new TypeElement(td);
                    JavaServiceUtil.determineCommit(dataModel, te);
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (CoreException)((Object)e));
            }
        }
    }

    private static void determineCommit(IDataModel dataModel, TypeElement typeElement) {
        if (typeElement.hasExplicitCommit()) {
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.IMPLICIT", false);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.EXPLICIT", true);
            return;
        }
        dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.EXPLICIT", false);
        dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.IMPLICIT", true);
    }

    /*
     * Exception decompiling
     */
    public static String findServiceDefinitionId(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractDesignTimeId(String text) {
        String s;
        Matcher matcher = DT_ID_PATTERN.matcher(text.trim());
        if (matcher.matches() && (s = matcher.group(2)) != null) {
            return s.trim();
        }
        return null;
    }
}

