/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.appgen.utils.DefaultJavaProjectFileProvider;
import oracle.eclipse.tools.common.services.appgen.utils.IWebProjectFileProvider;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class DefaultWebProjectFileProvider
extends DefaultJavaProjectFileProvider
implements IWebProjectFileProvider {
    public static final String FACES_CONFIG_DEFAULT_RELATIVE_PATH = "/WEB-INF/faces-config.xml";
    public static final String FACES_CONFIG_FILE_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";

    public DefaultWebProjectFileProvider(IProject project, String srcFolderName) {
        super(project, srcFolderName);
    }

    public IFile getWebInfFile(String name) {
        IPath path = this.getWebContentFolder().getProjectRelativePath().append("WEB-INF").append(name);
        return this.getProject().getFile(path);
    }

    public IFile getWebContentFile(String containerPath, String name) {
        IPath path = this.getWebContentFolder().getProjectRelativePath();
        if (containerPath != null && !containerPath.isEmpty()) {
            path = path.append(containerPath);
        }
        path = path.append(name);
        return this.getProject().getFile(path);
    }

    public IFile getWebContentFile(String location) {
        IPath path = this.getWebContentFolder().getProjectRelativePath();
        path = path.append(location);
        return this.getProject().getFile(path);
    }

    public IContainer getWebContentFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject());
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer underlyingFolder = rootFolder.getUnderlyingFolder();
        return underlyingFolder;
    }

    public Set<IFile> getFacesConfigFile(IProgressMonitor monitor) {
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance((IProject)this.getProject());
        if (facesConfigArtifact != null) {
            return facesConfigArtifact.getFacesConfigFiles();
        }
        return Collections.emptySet();
    }
}

