/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.templating;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.appgen.datamodel.ConcurrencyType;
import oracle.eclipse.tools.adf.view.appgen.datamodel.SessionType;
import oracle.eclipse.tools.adf.view.appgen.datamodel.TransactionType;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.ClassTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.IMethodBuilder;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SessionBeanTemplateBean
extends ClassTemplateBean {
    private static final String ID = "sessionBean";
    private final List<EntityTemplateBean> _entities = new ArrayList<EntityTemplateBean>();
    private final Map<EntityTemplateBean, List<IMethodBuilder>> _entityMethods = new HashMap<EntityTemplateBean, List<IMethodBuilder>>();
    private final String _classname;
    private IDataModel _dataModel;
    private String _localName;
    private String _remoteName;
    private String _name;
    private String _mappedName;
    private String _persistenceUnitName;

    public SessionBeanTemplateBean(String classname) {
        this._classname = classname;
    }

    public String getContextID() {
        return ID;
    }

    public String getClassName() {
        return this._classname;
    }

    public void setDataModel(IDataModel dataModel) {
        this._dataModel = dataModel;
    }

    public void setLocalName(String localName) {
        this._localName = localName;
    }

    public boolean hasLocal() {
        return this._localName != null && !this._localName.isEmpty();
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalSimpleName() {
        return ClassUtil.getClassName((String)this._localName);
    }

    public String getLocalPackage() {
        return SessionBeanTemplateBean.getPackage((String)this._localName);
    }

    public void setRemoteName(String remoteName) {
        this._remoteName = remoteName;
    }

    public boolean hasRemote() {
        return this._remoteName != null && !this._remoteName.isEmpty();
    }

    public String getRemoteName() {
        return this._remoteName;
    }

    public String getRemoteSimpleName() {
        return ClassUtil.getClassName((String)this._remoteName);
    }

    public String getRemotePackage() {
        return SessionBeanTemplateBean.getPackage((String)this._remoteName);
    }

    public List<String> getImports() {
        HashSet<String> implImports = new HashSet<String>();
        implImports.addAll(super.getImports());
        implImports.add("javax.annotation.Resource");
        implImports.add("javax.ejb.SessionContext");
        implImports.add("javax.persistence.EntityManager");
        implImports.add("javax.persistence.PersistenceContext");
        implImports.add("javax.persistence.Query");
        this.addSessionTypeImports(implImports);
        this.addTransactionTypeImports(implImports);
        this.addConcurrencyTypeImports(implImports);
        this.addMethodImports(implImports);
        ArrayList<String> arrayImps = new ArrayList<String>();
        arrayImps.addAll(implImports);
        Collections.sort(arrayImps);
        return arrayImps;
    }

    public List<String> getLocalImports() {
        HashSet<String> localImports = new HashSet<String>();
        localImports.addAll(super.getImports());
        localImports.add("javax.ejb.Local");
        this.addTransactionTypeInterfaceImports(localImports);
        ArrayList<String> arrayLocalImps = new ArrayList<String>();
        arrayLocalImps.addAll(localImports);
        Collections.sort(arrayLocalImps);
        return arrayLocalImps;
    }

    public List<String> getRemoteImports() {
        HashSet<String> remoteImports = new HashSet<String>();
        remoteImports.addAll(super.getImports());
        remoteImports.add("javax.ejb.Remote");
        this.addTransactionTypeInterfaceImports(remoteImports);
        ArrayList<String> arrayRemoteImps = new ArrayList<String>();
        arrayRemoteImps.addAll(remoteImports);
        Collections.sort(arrayRemoteImps);
        return arrayRemoteImps;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getMappedName() {
        return this._mappedName;
    }

    public void setMappedName(String mappedName) {
        this._mappedName = mappedName;
    }

    public String getPersistenceUnitName() {
        return this._persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this._persistenceUnitName = persistenceUnitName;
    }

    public String getSessionType() {
        if (this._dataModel == null) {
            return "Stateless";
        }
        SessionType sessionType = this.getSessionTypeEnum();
        switch (sessionType) {
            case STATELESS: {
                return "Stateless";
            }
            case STATEFUL: {
                return "Stateful";
            }
            case SINGLETON: {
                return "Singleton";
            }
        }
        return "Stateless";
    }

    public boolean hasStatefulSessionType() {
        return SessionType.STATEFUL.equals((Object)this.getSessionTypeEnum());
    }

    private void addSessionTypeImports(Collection<String> imports) {
        if (this._dataModel == null) {
            this.addImport("javax.ejb.Stateless");
        }
        SessionType sessionType = this.getSessionTypeEnum();
        switch (sessionType) {
            case STATELESS: {
                imports.add("javax.ejb.Stateless");
                break;
            }
            case STATEFUL: {
                imports.add("javax.ejb.Stateful");
                imports.add("javax.persistence.PersistenceContextType");
                break;
            }
            case SINGLETON: {
                imports.add("javax.ejb.Singleton");
                break;
            }
            default: {
                imports.add("javax.ejb.Stateless");
            }
        }
    }

    public TransactionType getTransactionType() {
        if (this._dataModel == null) {
            return null;
        }
        return TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
    }

    private void addTransactionTypeImports(Collection<String> imports) {
        if (this._dataModel == null) {
            return;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case CONTAINER_IMPLICIT: {
                imports.add("javax.ejb.TransactionAttribute");
                imports.add("javax.ejb.TransactionAttributeType");
                break;
            }
            case CONTAINER_EXPLICIT: {
                imports.add("javax.ejb.TransactionAttribute");
                imports.add("javax.ejb.TransactionAttributeType");
                break;
            }
            case BEAN_IMPLICIT: {
                imports.add("javax.ejb.TransactionManagement");
                imports.add("javax.ejb.TransactionManagementType");
                imports.add("javax.interceptor.AroundInvoke");
                imports.add("javax.interceptor.ExcludeClassInterceptors");
                imports.add("javax.interceptor.Interceptors");
                imports.add("javax.interceptor.InvocationContext");
                imports.add("javax.transaction.Status");
                imports.add("javax.transaction.UserTransaction");
                break;
            }
            case BEAN_EXPLICIT: {
                imports.add("javax.ejb.TransactionManagement");
                imports.add("javax.ejb.TransactionManagementType");
                imports.add("javax.interceptor.AroundInvoke");
                imports.add("javax.interceptor.ExcludeClassInterceptors");
                imports.add("javax.interceptor.Interceptors");
                imports.add("javax.interceptor.InvocationContext");
                imports.add("javax.transaction.HeuristicMixedException");
                imports.add("javax.transaction.HeuristicRollbackException");
                imports.add("javax.transaction.RollbackException");
                imports.add("javax.transaction.Status");
                imports.add("javax.transaction.SystemException");
                imports.add("javax.transaction.UserTransaction");
                break;
            }
        }
    }

    private void addTransactionTypeInterfaceImports(Collection<String> imports) {
        if (this._dataModel == null) {
            return;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case CONTAINER_IMPLICIT: {
                break;
            }
            case CONTAINER_EXPLICIT: {
                break;
            }
            case BEAN_IMPLICIT: {
                break;
            }
            case BEAN_EXPLICIT: {
                imports.add("javax.transaction.HeuristicMixedException");
                imports.add("javax.transaction.HeuristicRollbackException");
                imports.add("javax.transaction.RollbackException");
                imports.add("javax.transaction.SystemException");
                break;
            }
        }
    }

    public String getTransactionTypeAnnotation() {
        if (this._dataModel == null) {
            return null;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case CONTAINER_IMPLICIT: {
                return null;
            }
            case CONTAINER_EXPLICIT: {
                return "@TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)";
            }
            case BEAN_IMPLICIT: {
                return "@TransactionManagement(TransactionManagementType.BEAN)";
            }
            case BEAN_EXPLICIT: {
                return "@TransactionManagement(TransactionManagementType.BEAN)";
            }
        }
        return null;
    }

    public boolean hasBeanExplicit() {
        if (this._dataModel == null) {
            return false;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        return TransactionType.BEAN_EXPLICIT.compareTo(transactionType) == 0;
    }

    public boolean hasContainerExplicit() {
        if (this._dataModel == null) {
            return false;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        int value = TransactionType.CONTAINER_EXPLICIT.compareTo(transactionType);
        return TransactionType.CONTAINER_EXPLICIT.compareTo(transactionType) == 0;
    }

    public String getConcurrencyType() {
        if (this._dataModel != null) {
            return this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE");
        }
        return null;
    }

    private void addConcurrencyTypeImports(Collection<String> imports) {
        ConcurrencyType concurrencyType = ConcurrencyType.valueOf(this.getConcurrencyType());
        switch (concurrencyType) {
            case CONTAINER: {
                break;
            }
            case BEAN: {
                imports.add("javax.ejb.ConcurrencyManagement");
                imports.add("javax.ejb.ConcurrencyManagementType");
                break;
            }
        }
    }

    public String getConcurrencyTypeAnnotation() {
        if (this._dataModel == null) {
            return null;
        }
        ConcurrencyType concurrencyType = ConcurrencyType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE"));
        switch (concurrencyType) {
            case CONTAINER: {
                return null;
            }
            case BEAN: {
                return "@ConcurrencyManagement(ConcurrencyManagementType.BEAN)";
            }
        }
        return null;
    }

    public boolean hasCommit() {
        if (this._dataModel == null) {
            return false;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case BEAN_EXPLICIT: {
                return true;
            }
            case CONTAINER_EXPLICIT: {
                return true;
            }
            case CONTAINER_IMPLICIT: {
                return false;
            }
            case BEAN_IMPLICIT: {
                return false;
            }
        }
        return false;
    }

    public boolean hasInterceptor() {
        if (this._dataModel == null) {
            return false;
        }
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case BEAN_EXPLICIT: {
                return true;
            }
            case BEAN_IMPLICIT: {
                return true;
            }
            case CONTAINER_IMPLICIT: {
                return false;
            }
            case CONTAINER_EXPLICIT: {
                return false;
            }
        }
        return false;
    }

    public String getMethodTransactionAnnotation() {
        TransactionType transactionType = TransactionType.valueOf(this._dataModel.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE"));
        switch (transactionType) {
            case CONTAINER_IMPLICIT: {
                return "@TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)";
            }
            case BEAN_IMPLICIT: 
            case BEAN_EXPLICIT: {
                return "@ExcludeClassInterceptors";
            }
        }
        return null;
    }

    public void addEntity(EntityTemplateBean entityTB) {
        if (entityTB != null) {
            this._entities.add(entityTB);
            String beanPackage = this.getPackage();
            String entityPackage = entityTB.getPackage();
            if (entityPackage != null) {
                if (!entityPackage.equals(beanPackage)) {
                    this.addImport(entityTB.getClassName());
                }
            } else if (beanPackage != null) {
                this.addImport(entityTB.getClassName());
            }
        }
    }

    public List<EntityTemplateBean> getEntities() {
        return this._entities;
    }

    public void addEntityMethod(EntityTemplateBean entityTB, IMethodBuilder method) {
        List<IMethodBuilder> methods = this._entityMethods.get((Object)entityTB);
        if (methods == null) {
            methods = new ArrayList<IMethodBuilder>();
            this._entityMethods.put(entityTB, methods);
        }
        methods.add(method);
    }

    public List<IMethodBuilder> getEntityMethods(EntityTemplateBean entityTB) {
        List<IMethodBuilder> methods = this._entityMethods.get((Object)entityTB);
        if (methods == null) {
            return Collections.emptyList();
        }
        return methods;
    }

    private void addMethodImports(Collection<String> imports) {
        for (List<IMethodBuilder> methods : this._entityMethods.values()) {
            for (IMethodBuilder method : methods) {
                List impList = method.getImports();
                for (String imp : impList) {
                    imports.add(imp);
                }
            }
        }
    }

    public String propertyLower(String propertyName) {
        return StringUtil.initLower((String)propertyName);
    }

    private SessionType getSessionTypeEnum() {
        if (this._dataModel == null) {
            return SessionType.STATELESS;
        }
        if (this._dataModel.getBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS")) {
            return SessionType.STATELESS;
        }
        if (this._dataModel.getBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL")) {
            return SessionType.STATEFUL;
        }
        if (this._dataModel.getBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON")) {
            return SessionType.SINGLETON;
        }
        return SessionType.STATELESS;
    }
}

