/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.templating;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanNamedQueryMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.ClassTemplateBean;

public class ManagedBeanTemplateBean
extends ClassTemplateBean {
    private static final String ID = "managedBean";
    private final Map<EntityTemplateBean, List<SessionBeanNamedQueryMethodBuilder>> _namedQueryEntityMethods = new HashMap<EntityTemplateBean, List<SessionBeanNamedQueryMethodBuilder>>();
    private final List<EntityTemplateBean> _entities = new ArrayList<EntityTemplateBean>();
    private final String _beanName;
    private final String _name;

    public ManagedBeanTemplateBean(String name) {
        this._name = name;
        String temp = this.getSimpleName();
        this._beanName = String.valueOf(temp.substring(0, 1).toLowerCase()) + temp.substring(1);
    }

    public String getContextID() {
        return ID;
    }

    public String getBeanName() {
        return this._beanName;
    }

    public String getClassName() {
        return this._name;
    }

    public void addEntity(EntityTemplateBean entityTB) {
        if (entityTB != null) {
            this._entities.add(entityTB);
            String beanPackage = this.getPackage();
            String entityPackage = entityTB.getPackage();
            if (entityPackage != null) {
                if (!entityPackage.equals(beanPackage)) {
                    this.addImport(entityTB.getClassName());
                }
            } else if (beanPackage != null) {
                this.addImport(entityTB.getClassName());
            }
        }
    }

    public List<EntityTemplateBean> getEntities() {
        return this._entities;
    }

    public List<SessionBeanNamedQueryMethodBuilder> getNamedQueryEntityMethods(EntityTemplateBean entityTB) {
        List<SessionBeanNamedQueryMethodBuilder> methods = this._namedQueryEntityMethods.get((Object)entityTB);
        if (methods == null) {
            return Collections.emptyList();
        }
        return methods;
    }

    public void addNamedQueryEntityMethod(EntityTemplateBean entityTB, SessionBeanNamedQueryMethodBuilder method) {
        List<SessionBeanNamedQueryMethodBuilder> methods = this._namedQueryEntityMethods.get((Object)entityTB);
        if (methods == null) {
            methods = new ArrayList<SessionBeanNamedQueryMethodBuilder>();
            this._namedQueryEntityMethods.put(entityTB, methods);
        }
        methods.add(method);
    }
}

