/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.templating;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.ClassTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.IMethodBuilder;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JavaServiceTemplateBean
extends ClassTemplateBean {
    private static final String ID = "javaService";
    private final List<EntityTemplateBean> _entities = new ArrayList<EntityTemplateBean>();
    private final Map<EntityTemplateBean, List<IMethodBuilder>> _entityMethods = new HashMap<EntityTemplateBean, List<IMethodBuilder>>();
    private final String _classname;
    private IDataModel _dataModel;
    private String _persistenceUnitName;

    public JavaServiceTemplateBean(String classname) {
        this._classname = classname;
    }

    public String getContextID() {
        return ID;
    }

    public String getClassName() {
        return this._classname;
    }

    public void setDataModel(IDataModel dataModel) {
        this._dataModel = dataModel;
    }

    public List<String> getImports() {
        HashSet<String> implImports = new HashSet<String>();
        implImports.addAll(super.getImports());
        implImports.add("javax.persistence.EntityManager");
        implImports.add("javax.persistence.EntityManagerFactory");
        implImports.add("javax.persistence.EntityTransaction");
        implImports.add("javax.persistence.Persistence");
        implImports.add("javax.persistence.Query");
        this.addMethodImports(implImports);
        ArrayList<String> arrayImps = new ArrayList<String>();
        arrayImps.addAll(implImports);
        Collections.sort(arrayImps);
        return arrayImps;
    }

    public String getPersistenceUnitName() {
        return this._persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this._persistenceUnitName = persistenceUnitName;
    }

    public boolean hasImplicitCommit() {
        if (this._dataModel == null) {
            return false;
        }
        return this._dataModel.getBooleanProperty("IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.IMPLICIT");
    }

    public void addEntity(EntityTemplateBean entityTB) {
        if (entityTB != null) {
            this._entities.add(entityTB);
            String beanPackage = this.getPackage();
            String entityPackage = entityTB.getPackage();
            if (entityPackage != null) {
                if (!entityPackage.equals(beanPackage)) {
                    this.addImport(entityTB.getClassName());
                }
            } else if (beanPackage != null) {
                this.addImport(entityTB.getClassName());
            }
        }
    }

    public List<EntityTemplateBean> getEntities() {
        return this._entities;
    }

    public void addEntityMethod(EntityTemplateBean entityTB, IMethodBuilder method) {
        List<IMethodBuilder> methods = this._entityMethods.get((Object)entityTB);
        if (methods == null) {
            methods = new ArrayList<IMethodBuilder>();
            this._entityMethods.put(entityTB, methods);
        }
        methods.add(method);
    }

    public List<IMethodBuilder> getEntityMethods(EntityTemplateBean entityTB) {
        List<IMethodBuilder> methods = this._entityMethods.get((Object)entityTB);
        if (methods == null) {
            return Collections.emptyList();
        }
        return methods;
    }

    private void addMethodImports(Collection<String> imports) {
        for (List<IMethodBuilder> methods : this._entityMethods.values()) {
            for (IMethodBuilder method : methods) {
                List impList = method.getImports();
                for (String imp : impList) {
                    imports.add(imp);
                }
            }
        }
    }

    public String propertyLower(String propertyName) {
        return StringUtil.initLower((String)propertyName);
    }
}

