/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.participants.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.ManagedBeanFromSessionBeanGenContextFactory;
import oracle.eclipse.tools.adf.view.appgen.templating.ManagedBeanTemplateBean;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.utils.IWebProjectFileProvider;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class FacesConfigManagedBean
extends ResourceChange
implements IGenerationParticipant {
    private static final String SESSION_SCOPE = "session";
    private IWebProjectFileProvider _project;
    private FacesConfigArtifactEdit _facesConfigEdit = null;
    private IServiceDefinitionInfo _sdInfo;
    private ChangeType _type;
    private ManagedBeanTemplateBean _managedBean;
    private IFile _facesConfigFile;

    public FacesConfigManagedBean(IWebProjectFileProvider webProjectFileProvider, IServiceDefinitionInfo sdInfo, ChangeType type) {
        this._project = webProjectFileProvider;
        this._sdInfo = sdInfo;
        this._type = type;
        this.initialize();
    }

    private void initialize() {
        this._managedBean = ManagedBeanFromSessionBeanGenContextFactory.getControllerBeanTemplateBean(this._sdInfo);
        this._facesConfigFile = this.findFacesConfig(this._project.getFacesConfigFile((IProgressMonitor)new NullProgressMonitor()));
    }

    protected IResource getModifiedResource() {
        return this.findFacesConfig(this._project.getFacesConfigFile((IProgressMonitor)new NullProgressMonitor()));
    }

    public String getName() {
        return "Edit Faces Config";
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        switch (this._type) {
            case ADD: {
                return this.performAdd(pm);
            }
            case REMOVE: {
                return this.performRemove(pm);
            }
        }
        return null;
    }

    public Change performAdd(IProgressMonitor pm) throws CoreException {
        try {
            this._facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this._facesConfigFile.getProject(), (String)this.getFacesConfigName(this._facesConfigFile));
            FacesConfigFactory facesConfigFactory = FacesConfigPackage.eINSTANCE.getFacesConfigFactory();
            ManagedBeanType managedBean = facesConfigFactory.createManagedBeanType();
            ManagedBeanNameType name = facesConfigFactory.createManagedBeanNameType();
            name.setTextContent(this._managedBean.getBeanName());
            managedBean.setManagedBeanName(name);
            ManagedBeanClassType clazz = facesConfigFactory.createManagedBeanClassType();
            clazz.setTextContent(this._managedBean.getClassName());
            managedBean.setManagedBeanClass(clazz);
            ManagedBeanScopeType scope = facesConfigFactory.createManagedBeanScopeType();
            scope.setTextContent(SESSION_SCOPE);
            managedBean.setManagedBeanScope(scope);
            this._facesConfigEdit.getFacesConfig().getManagedBean().add((Object)managedBean);
            this.save(this._facesConfigEdit);
            FacesConfigManagedBean facesConfigManagedBean = new FacesConfigManagedBean(this._project, this._sdInfo, ChangeType.REMOVE);
            return facesConfigManagedBean;
        }
        finally {
            if (this._facesConfigEdit != null) {
                this._facesConfigEdit.dispose();
                this._facesConfigEdit = null;
            }
        }
    }

    public Change performRemove(IProgressMonitor pm) throws CoreException {
        try {
            this._facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this._facesConfigFile.getProject(), (String)this.getFacesConfigName(this._facesConfigFile));
            if (this._facesConfigEdit.getFacesConfig() == null) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "Non-null FacesConfigArtifactEdit expected"));
            }
            Iterator it = this._facesConfigEdit.getFacesConfig().getManagedBean().iterator();
            while (it.hasNext()) {
                if (!((ManagedBeanType)it.next()).getManagedBeanName().getTextContent().equals(this._managedBean.getBeanName())) continue;
                it.remove();
            }
            this._facesConfigEdit.save(null);
            FacesConfigManagedBean facesConfigManagedBean = new FacesConfigManagedBean(this._project, this._sdInfo, ChangeType.ADD);
            return facesConfigManagedBean;
        }
        finally {
            if (this._facesConfigEdit != null) {
                this._facesConfigEdit.dispose();
                this._facesConfigEdit = null;
            }
        }
    }

    private void save(FacesConfigArtifactEdit fcArtifactEdit) {
        if (fcArtifactEdit != null) {
            Resource resource;
            IStatus status;
            IWorkspace workspace;
            IProject project;
            IFile file = fcArtifactEdit.getFile();
            if (file != null && file.isAccessible() && (project = file.getProject()) != null && project.isAccessible() && (workspace = project.getWorkspace()) != null && !(status = workspace.validateEdit(new IFile[]{file}, null)).isOK()) {
                LoggingService.logError((Plugin)ADFPlugin.getDefault(), (String)status.getMessage());
            }
            if ((resource = fcArtifactEdit.getDeploymentDescriptorResource()) != null) {
                try {
                    resource.save(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    LoggingService.logError((Plugin)ADFPlugin.getDefault(), (String)ioe.getLocalizedMessage());
                }
            }
        }
    }

    private IFile findFacesConfig(Set<IFile> facesConfigFileSet) {
        Iterator<IFile> iterator = facesConfigFileSet.iterator();
        if (iterator.hasNext()) {
            IFile facesConfig = iterator.next();
            return facesConfig;
        }
        return null;
    }

    private String getFacesConfigName(IFile facesConfig) {
        String facesConfigFile = null;
        IPath fcConfigPath = facesConfig.getProjectRelativePath();
        facesConfigFile = fcConfigPath.toString();
        if (facesConfigFile != null && facesConfigFile.startsWith("/")) {
            facesConfigFile = facesConfigFile.substring(1);
        }
        return facesConfigFile;
    }

    public Set<IGenerationContextFactory.GenerationOption> getParticipantGenerationOption() {
        return EnumSet.of(IGenerationContextFactory.GenerationOption.MANAGED_BEAN);
    }

    public boolean isValid() {
        if (this._facesConfigFile == null) {
            return false;
        }
        if (this._managedBean == null) {
            return false;
        }
        try {
            this._facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)this._facesConfigFile.getProject(), (String)this.getFacesConfigName(this._facesConfigFile));
            if (this._facesConfigEdit == null) {
                return false;
            }
            FacesConfigType fcType = this._facesConfigEdit.getFacesConfig();
            if (fcType == null) {
                return false;
            }
            Iterator it = fcType.getManagedBean().iterator();
            while (it.hasNext()) {
                if (!((ManagedBeanType)it.next()).getManagedBeanName().getTextContent().equals(this._managedBean.getBeanName())) continue;
                return !ChangeType.ADD.equals((Object)this._type);
                {
                }
            }
            if (ChangeType.ADD.equals((Object)this._type)) {
                return true;
            }
        }
        finally {
            if (this._facesConfigEdit != null) {
                this._facesConfigEdit.dispose();
                this._facesConfigEdit = null;
            }
        }
        return false;
    }

    public static enum ChangeType {
        ADD,
        REMOVE;

    }
}

