/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.generators.internal;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.AbstractServiceGenerationContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.ArtifactNames;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanNamedQueryMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanRemoveMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.adf.view.appgen.templating.SessionBeanTemplateBean;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanUtil;
import oracle.eclipse.tools.common.services.appgen.generators.DefaultContext;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.templating.AbstractTemplateBean;
import oracle.eclipse.tools.common.services.appgen.utils.IJavaProjectFileProvider;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.javaee.ejb.SessionBean;

public class SessionBeanFromEntitiesGenContextFactory
extends AbstractServiceGenerationContextFactory {
    private static final String JAVA_UTIL_LIST_TYPE = "java.util.List";
    private static final String LOCAL_INTERFACE_DEFAULT_NAME_EXT = "Local";
    private static final String REMOTE_INTERFACE_DEFAULT_NAME_EXT = "Remote";
    private final IJavaProjectFileProvider _fileProvider;
    private SessionBeanTemplateBean _sessionBeanTB;

    public SessionBeanFromEntitiesGenContextFactory(IServiceDefinitionInfo sdInfo, IJavaProjectFileProvider modelFileProvider) {
        super(sdInfo);
        this._fileProvider = modelFileProvider;
    }

    public List<IGenerationContext> getGenerationContexts() throws GenerationException {
        ArrayList<IGenerationContext> contexts = new ArrayList<IGenerationContext>();
        this.addSessionBeanContext(contexts);
        SessionBeanTemplateBean sessionBeanTB = this.getSessionBeanTemplateBean();
        if (sessionBeanTB.hasLocal()) {
            this.addInterfaceContext(contexts, false);
        }
        if (sessionBeanTB.hasRemote()) {
            this.addInterfaceContext(contexts, true);
        }
        return contexts;
    }

    private void addSessionBeanContext(List<IGenerationContext> contexts) {
        SessionBeanTemplateBean sessionBeanTB = this.getSessionBeanTemplateBean();
        String classname = sessionBeanTB.getClassName();
        String desc = String.format(ArtifactNames.SESSION_BEAN, classname);
        IFile targetFile = this._fileProvider.getJavaFile(classname);
        DefaultContext context = new DefaultContext(desc, targetFile, "oracle.eclipse.tools.adf.view.appgen.templating.sessionBean");
        context.addContextObject((ITemplateBean)sessionBeanTB);
        contexts.add((IGenerationContext)context);
    }

    private void addInterfaceContext(List<IGenerationContext> contexts, boolean isRemote) {
        SessionBeanTemplateBean sessionBeanTB = this.getSessionBeanTemplateBean();
        String name = isRemote ? sessionBeanTB.getRemoteName() : sessionBeanTB.getLocalName();
        String interfacePackage = ClassUtil.getPackageName((String)name);
        String beanPackage = sessionBeanTB.getPackage();
        if (interfacePackage != null) {
            if (!interfacePackage.equals(beanPackage)) {
                sessionBeanTB.addImport(name);
            }
        } else if (beanPackage != null) {
            sessionBeanTB.addImport(name);
        }
        String desc = String.format(ArtifactNames.SESSION_BEAN, name);
        IFile targetFile = this._fileProvider.getJavaFile(name);
        DefaultContext context = new DefaultContext(desc, targetFile, "oracle.eclipse.tools.adf.view.appgen.templating.sessionBeanInterface");
        context.addContextObject((ITemplateBean)sessionBeanTB);
        context.addContextObject((ITemplateBean)new InterfaceInfoTemplateBean(isRemote));
        contexts.add((IGenerationContext)context);
    }

    private SessionBeanTemplateBean getSessionBeanTemplateBean() {
        if (this._sessionBeanTB == null) {
            this._sessionBeanTB = SessionBeanFromEntitiesGenContextFactory.getSessionBeanTemplateBean(this.getServiceDefinitionInfo());
        }
        return this._sessionBeanTB;
    }

    static SessionBeanTemplateBean getSessionBeanTemplateBean(IServiceDefinitionInfo sdInfo) {
        if (sdInfo == null) {
            return null;
        }
        StringBuilder fullNameBuilder = new StringBuilder(256);
        String beanName = sdInfo.getSessionBeanName();
        String pkg = sdInfo.getSessionBeanPackage();
        if (beanName == null || beanName.isEmpty()) {
            return null;
        }
        if (pkg != null && !pkg.isEmpty()) {
            fullNameBuilder.append(pkg);
            fullNameBuilder.append('.');
        }
        fullNameBuilder.append(beanName);
        String classname = fullNameBuilder.toString();
        SessionBeanTemplateBean sessionBeanTB = new SessionBeanTemplateBean(classname);
        IProject project = sdInfo.getSessionBeanProject();
        SessionBean sessionBean = SessionBeanUtil.getSessionBean(project, classname);
        if (sessionBean != null) {
            List remotes;
            List locals = sessionBean.getBusinessLocals();
            if (locals != null && locals.size() > 0) {
                sessionBeanTB.setLocalName((String)locals.get(0));
            }
            if ((remotes = sessionBean.getBusinessRemotes()) != null && remotes.size() > 0) {
                sessionBeanTB.setRemoteName((String)remotes.get(0));
            }
            sessionBeanTB.setName(sessionBean.getEjbName());
            sessionBeanTB.setMappedName(sessionBean.getMappedName());
        } else {
            sessionBeanTB.setLocalName(String.valueOf(classname) + LOCAL_INTERFACE_DEFAULT_NAME_EXT);
            sessionBeanTB.setRemoteName(String.valueOf(classname) + REMOTE_INTERFACE_DEFAULT_NAME_EXT);
            String name = SessionBeanFromEntitiesGenContextFactory.getUniqueBeanName(project, classname, beanName);
            if (name != null) {
                sessionBeanTB.setName(name);
                sessionBeanTB.setMappedName(SessionBeanFromEntitiesGenContextFactory.getMappedName(project, name));
            }
        }
        sessionBeanTB.setDataModel(sdInfo.getDataModel());
        String designTimeId = SessionBeanFromEntitiesGenContextFactory.getDesignTimeId(sdInfo);
        if (designTimeId != null) {
            sessionBeanTB.setDesignTimeId(designTimeId);
        }
        boolean needPUName = true;
        for (IEntityInfo iEntityInfo : sdInfo.getEntityInfoList()) {
            EntityTemplateBean entityTB = new EntityTemplateBean(iEntityInfo);
            entityTB.setDesignTimeId(designTimeId);
            sessionBeanTB.addEntity(entityTB);
            SessionBeanFromEntitiesGenContextFactory.addRemoveMethodForEntity(sessionBeanTB, iEntityInfo, entityTB);
            SessionBeanFromEntitiesGenContextFactory.addNamedQueryMethods(sessionBeanTB, iEntityInfo, entityTB);
            if (!needPUName) continue;
            sessionBeanTB.setPersistenceUnitName(SessionBeanFromEntitiesGenContextFactory.getPersistenceUnitName(iEntityInfo));
            needPUName = false;
        }
        return sessionBeanTB;
    }

    private static String getUniqueBeanName(IProject project, String classname, String name) {
        if (SessionBeanUtil.validateBeanName(project, name)) {
            return name;
        }
        StringBuilder newName = new StringBuilder();
        if (classname != null) {
            String[] tokens = classname.split("\\.");
            newName.append(tokens[0]);
            int i = 1;
            while (i < tokens.length) {
                newName.append(StringUtil.initUpper((String)tokens[i]));
                ++i;
            }
        } else {
            return null;
        }
        return newName.toString();
    }

    private static String getMappedName(IProject project, String name) {
        if (name == null) {
            return null;
        }
        StringBuilder mappedName = new StringBuilder();
        if (project != null) {
            IProject[] earProjects = EarUtilities.getReferencingEARProjects((IProject)project);
            if (earProjects != null && earProjects.length == 1) {
                mappedName.append(earProjects[0].getName());
                mappedName.append('-');
            }
            mappedName.append(project.getName());
            mappedName.append('-');
        }
        mappedName.append(name);
        return mappedName.toString();
    }

    private static void addRemoveMethodForEntity(SessionBeanTemplateBean sessionBeanTB, IEntityInfo entityInfo, EntityTemplateBean entityTB) {
        SessionBeanRemoveMethodBuilder removeMethod = new SessionBeanRemoveMethodBuilder(sessionBeanTB, entityInfo, entityTB);
        removeMethod.init();
        sessionBeanTB.addEntityMethod(entityTB, removeMethod);
    }

    private static void addNamedQueryMethods(SessionBeanTemplateBean sessionBeanTB, IEntityInfo entityInfo, EntityTemplateBean entityTB) {
        ListIterator<? extends NamedQuery> namedQueries = entityInfo.getNamedQueryObjects();
        if (namedQueries != null && namedQueries.hasNext()) {
            sessionBeanTB.addImport(JAVA_UTIL_LIST_TYPE);
            while (namedQueries.hasNext()) {
                NamedQuery query = namedQueries.next();
                SessionBeanNamedQueryMethodBuilder namedQueryMethod = new SessionBeanNamedQueryMethodBuilder(entityTB, query, sessionBeanTB.getTransactionType(), entityInfo.getJpaProject());
                sessionBeanTB.addEntityMethod(entityTB, namedQueryMethod);
            }
        }
    }

    private static String getPersistenceUnitName(IEntityInfo entityInfo) {
        String puName = entityInfo.getEntity().getPersistenceUnit().getName();
        if (puName == null) {
            puName = "";
        }
        return puName;
    }

    public List<IGenerationParticipant> getGenerationParticipants() {
        return null;
    }

    public static class InterfaceInfoTemplateBean
    extends AbstractTemplateBean {
        private static final String ID = "interfaceInfo";
        private final boolean _isRemote;

        public InterfaceInfoTemplateBean(boolean isRemote) {
            this._isRemote = isRemote;
        }

        public String getContextID() {
            return ID;
        }

        public boolean isRemote() {
            return this._isRemote;
        }
    }
}

