/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.generators.internal;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.AbstractServiceGenerationContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.ArtifactNames;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanFromEntitiesGenContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanNamedQueryMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.participants.GenerationParticipantFactory;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.adf.view.appgen.templating.ManagedBeanTemplateBean;
import oracle.eclipse.tools.adf.view.appgen.templating.SessionBeanTemplateBean;
import oracle.eclipse.tools.common.services.appgen.generators.DefaultContext;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.utils.IWebProjectFileProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.jpa.core.context.NamedQuery;

public class ManagedBeanFromSessionBeanGenContextFactory
extends AbstractServiceGenerationContextFactory {
    private static final String EJB_ANNOTATION_TYPE = "javax.ejb.EJB";
    private static final String JAVA_UTIL_LIST_TYPE = "java.util.List";
    private final IWebProjectFileProvider _fileProvider;

    public ManagedBeanFromSessionBeanGenContextFactory(IServiceDefinitionInfo sdInfo, IWebProjectFileProvider webFileProvider) {
        super(sdInfo);
        this._fileProvider = webFileProvider;
    }

    public List<IGenerationContext> getGenerationContexts() throws GenerationException {
        ArrayList<IGenerationContext> contexts = new ArrayList<IGenerationContext>();
        SessionBeanTemplateBean sessionBeanTB = SessionBeanFromEntitiesGenContextFactory.getSessionBeanTemplateBean(this.getServiceDefinitionInfo());
        ManagedBeanTemplateBean managedBeanTB = ManagedBeanFromSessionBeanGenContextFactory.getControllerBeanTemplateBean(this.getServiceDefinitionInfo());
        String desc = String.format(ArtifactNames.MANAGED_BEAN, managedBeanTB.getClassName());
        IFile targetFile = this._fileProvider.getJavaFile(managedBeanTB.getClassName());
        DefaultContext context = new DefaultContext(desc, targetFile, "oracle.eclipse.tools.adf.view.appgen.templating.controllerBean");
        contexts.add((IGenerationContext)context);
        context.addContextObject((ITemplateBean)managedBeanTB);
        context.addContextObject((ITemplateBean)sessionBeanTB);
        managedBeanTB.addImport(sessionBeanTB.getLocalName());
        managedBeanTB.addImport(EJB_ANNOTATION_TYPE);
        return contexts;
    }

    public static ManagedBeanTemplateBean getControllerBeanTemplateBean(IServiceDefinitionInfo sdInfo) {
        if (sdInfo == null) {
            return null;
        }
        StringBuilder classname = new StringBuilder(256);
        String name = sdInfo.getManagedBeanName();
        String pkg = sdInfo.getManagedBeanPackage();
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (pkg != null && !pkg.isEmpty()) {
            classname.append(pkg);
            classname.append('.');
        }
        classname.append(name);
        ManagedBeanTemplateBean templateBean = new ManagedBeanTemplateBean(classname.toString());
        String designTimeId = ManagedBeanFromSessionBeanGenContextFactory.getDesignTimeId(sdInfo);
        if (designTimeId != null) {
            templateBean.setDesignTimeId(designTimeId);
        }
        for (IEntityInfo iEntityInfo : sdInfo.getEntityInfoList()) {
            EntityTemplateBean entityTB = new EntityTemplateBean(iEntityInfo);
            if (designTimeId != null) {
                entityTB.setDesignTimeId(designTimeId);
            }
            templateBean.addEntity(entityTB);
            ManagedBeanFromSessionBeanGenContextFactory.addNamedQueryMethods(templateBean, iEntityInfo, entityTB);
        }
        return templateBean;
    }

    public List<IGenerationParticipant> getGenerationParticipants() {
        GenerationParticipantFactory factory = new GenerationParticipantFactory(this.getServiceDefinitionInfo(), this._fileProvider, EnumSet.of(IGenerationContextFactory.GenerationOption.MANAGED_BEAN));
        return factory.getGenerationParticipants();
    }

    private static void addNamedQueryMethods(ManagedBeanTemplateBean managedBeanTB, IEntityInfo entityInfo, EntityTemplateBean entityTB) {
        ListIterator<? extends NamedQuery> namedQueries = entityInfo.getNamedQueryObjects();
        if (namedQueries != null && namedQueries.hasNext()) {
            managedBeanTB.addImport(JAVA_UTIL_LIST_TYPE);
            while (namedQueries.hasNext()) {
                NamedQuery query = namedQueries.next();
                SessionBeanNamedQueryMethodBuilder namedQueryMethod = new SessionBeanNamedQueryMethodBuilder(entityTB, query, null, entityInfo.getJpaProject());
                managedBeanTB.addNamedQueryEntityMethod(entityTB, namedQueryMethod);
            }
        }
    }
}

