/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.generators.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.common.services.appgen.templating.IMethodBuilder;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.jpql.spi.GenericMappingBuilder;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaQuery;
import org.eclipse.jpt.jpa.gen.internal.util.EntityGenTools;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.DefaultJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.tools.DefaultJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;

public abstract class AbstractNamedQueryMethodBuilder
implements IMethodBuilder {
    private static final String JAVA_LANG_STR = "java.lang.";
    private final JPQLHelper _jpqlHelper = new JPQLHelper();
    private String _returnType;
    private String _signature;
    private String _signatureNoTypes;
    private String _impl;

    public AbstractNamedQueryMethodBuilder(EntityTemplateBean entityTB, NamedQuery query, JpaProject jpaProject) {
        this._jpqlHelper.parseQuery(jpaProject, query);
        this.computeMethodInfo(entityTB, query);
    }

    private void computeMethodInfo(EntityTemplateBean entityTB, NamedQuery query) {
        switch (this._jpqlHelper.queryType) {
            case SELECT: {
                StringBuilder sb = new StringBuilder();
                sb.append("List<");
                sb.append(entityTB.getSimpleName());
                sb.append('>');
                this._returnType = sb.toString();
                this.computeSelectStmtSignature(query);
                this.computeSelectStmtImpl(query);
            }
        }
    }

    public String getAccess() {
        return "public";
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getSignature() {
        return this._signature;
    }

    public String getSignatureNoTypes() {
        return this._signatureNoTypes;
    }

    public String getImpl() {
        return this._impl;
    }

    private void computeSelectStmtSignature(NamedQuery query) {
        StringBuilder signature = new StringBuilder();
        StringBuilder signatureNoTypes = new StringBuilder();
        signature.append("get");
        String queryName = query.getName();
        queryName = EntityGenTools.convertToUniqueJavaStyleIdentifier((String)queryName, (boolean)true, Collections.emptySet());
        queryName = AbstractNamedQueryMethodBuilder.removeUnderscore(queryName, true);
        signature.append(queryName);
        signature.append('(');
        signatureNoTypes.append(signature.toString());
        if (this._jpqlHelper.parameters != null && this._jpqlHelper.parameters.size() > 0) {
            for (InputParameter param : this._jpqlHelper.parameters) {
                String paramName = (String)this._jpqlHelper.paramNameMap.get(param);
                if (paramName == null) continue;
                IType type = (IType)this._jpqlHelper.paramMap.get(param);
                String typeName = type.getName();
                if (typeName.startsWith(JAVA_LANG_STR)) {
                    signature.append(typeName.substring(JAVA_LANG_STR.length()));
                } else {
                    signature.append(typeName);
                }
                signature.append(' ');
                signature.append(paramName);
                signatureNoTypes.append(paramName);
                signature.append(", ");
                signatureNoTypes.append(", ");
            }
            if (signature.toString().endsWith(", ")) {
                int len = signature.length();
                signature.delete(len - 2, len);
            }
            if (signatureNoTypes.toString().endsWith(", ")) {
                int len = signatureNoTypes.length();
                signatureNoTypes.delete(len - 2, len);
            }
        }
        signature.append(')');
        signatureNoTypes.append(')');
        this._signature = signature.toString();
        this._signatureNoTypes = signatureNoTypes.toString();
    }

    private void computeSelectStmtImpl(NamedQuery query) {
        StringBuilder impl = new StringBuilder();
        impl.append("return em.createNamedQuery(\"");
        impl.append(query.getName());
        impl.append("\")");
        if (this._jpqlHelper.parameters != null && this._jpqlHelper.parameters.size() > 0) {
            for (InputParameter param : this._jpqlHelper.parameters) {
                String paramName = (String)this._jpqlHelper.paramNameMap.get(param);
                if (paramName == null) continue;
                impl.append(".setParameter(");
                if (param.isNamed()) {
                    impl.append("\"");
                    impl.append(paramName);
                    impl.append("\"");
                } else if (param.isPositional()) {
                    impl.append(param.getParameter().substring(1));
                }
                impl.append(", ");
                impl.append(paramName);
                impl.append(")");
            }
        }
        impl.append(".getResultList();");
        this._impl = impl.toString();
    }

    private static String removeUnderscore(String str, boolean capitalizeTokensFirstLetter) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, "_");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (capitalizeTokensFirstLetter) {
                token = StringUtil.initUpper((String)token);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private static class JPQLHelper
    extends DefaultJPQLQueryHelper {
        private QueryType queryType;
        private Collection<InputParameter> parameters;
        private Map<InputParameter, IType> paramMap = null;
        private Map<InputParameter, String> paramNameMap = null;

        JPQLHelper() {
            super(DefaultJPQLGrammar.instance());
        }

        private void parseQuery(JpaProject jpaProject, NamedQuery namedQuery) {
            JpaManagedTypeProvider jpaManagedTypeProvider = new JpaManagedTypeProvider(jpaProject, (PersistentTypeContainer)namedQuery.getPersistenceUnit(), (IMappingBuilder)new GenericMappingBuilder());
            JpaQuery jpaQuery = new JpaQuery((IManagedTypeProvider)jpaManagedTypeProvider, namedQuery);
            this.setQuery((IQuery)jpaQuery);
            QueryStatementVisitor visitor = new QueryStatementVisitor();
            this.getQueryContext().getJPQLExpression().accept((ExpressionVisitor)visitor);
            this.queryType = visitor.queryType;
            this.parameters = this.getInputParameters(this.getQueryContext().getJPQLExpression());
            for (InputParameter param : this.parameters) {
                if (this.paramMap == null) {
                    this.paramMap = new HashMap<InputParameter, IType>();
                }
                if (this.paramNameMap == null) {
                    this.paramNameMap = new HashMap<InputParameter, String>();
                }
                IType type = this.getParameterType(param.getParameter());
                this.paramMap.put(param, type);
                String paramName = "";
                if (param.isPositional()) {
                    paramName = param.getParameter().substring(1);
                    paramName = "param" + paramName;
                } else {
                    if (!param.isNamed()) continue;
                    paramName = param.getParameter().substring(1);
                }
                this.paramNameMap.put(param, paramName);
            }
        }

        private Collection<InputParameter> getInputParameters(JPQLExpression jpqlExpression) {
            InputParameterVisitor visitor = new InputParameterVisitor();
            jpqlExpression.accept((ExpressionVisitor)visitor);
            return visitor.inputParameters;
        }

        private class InputParameterVisitor
        extends AbstractTraverseChildrenVisitor {
            private HashSet<String> uniqueParams = new HashSet();
            Collection<InputParameter> inputParameters = new ArrayList<InputParameter>();

            private InputParameterVisitor() {
            }

            public void visit(InputParameter param) {
                if (!this.uniqueParams.contains(param.getParameter())) {
                    this.inputParameters.add(param);
                    this.uniqueParams.add(param.getParameter());
                }
            }
        }
    }

    private static class QueryStatementVisitor
    extends AnonymousExpressionVisitor {
        private QueryType queryType;

        private QueryStatementVisitor() {
        }

        public void visit(DeleteStatement expression) {
            this.queryType = QueryType.DELETE;
        }

        protected void visit(Expression expression) {
            this.queryType = QueryType.UNKNOWN;
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            this.queryType = QueryType.SELECT;
        }

        public void visit(UpdateStatement expression) {
            this.queryType = QueryType.UPDATE;
        }
    }

    private static enum QueryType {
        DELETE,
        SELECT,
        UNKNOWN,
        UPDATE;

    }
}

