/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.generators;

import java.util.Set;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.JavaServiceFromEntitiesGenContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.ManagedBeanFromSessionBeanGenContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.SessionBeanFromEntitiesGenContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.CompositeGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.utils.IJavaProjectFileProvider;
import oracle.eclipse.tools.common.services.appgen.utils.IWebProjectFileProvider;
import oracle.eclipse.tools.common.util.logging.LoggingService;

public class ServiceGeneratorFactory {
    public static IGenerationContextFactory createGenerationContextFactory(IServiceDefinitionInfo modelSDInfo, IServiceDefinitionInfo webAppSDInfo, IJavaProjectFileProvider modelFileProvider, IWebProjectFileProvider webFileProvider, Set<IGenerationContextFactory.GenerationOption> options) {
        if (options == null || options.isEmpty()) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Missing generation options");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        if (options.contains(IGenerationContextFactory.GenerationOption.SESSION_BEAN) && modelSDInfo == null || options.contains(IGenerationContextFactory.GenerationOption.MANAGED_BEAN) && webAppSDInfo == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: AppSpecModel is null");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        if (options.contains(IGenerationContextFactory.GenerationOption.SESSION_BEAN) && modelFileProvider == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Project model file provider is null");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        if ((options.contains(IGenerationContextFactory.GenerationOption.MANAGED_BEAN) || options.contains(IGenerationContextFactory.GenerationOption.TASKFLOW)) && webFileProvider == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Project web file provider is null");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        if (options.contains(IGenerationContextFactory.GenerationOption.JAVA_SERVICE) && modelFileProvider == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Project model file provider is null");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        if (!options.isEmpty()) {
            CompositeGenerationContextFactory contextFactory = new CompositeGenerationContextFactory();
            if (options.contains(IGenerationContextFactory.GenerationOption.SESSION_BEAN)) {
                contextFactory.add((IGenerationContextFactory)new SessionBeanFromEntitiesGenContextFactory(modelSDInfo, modelFileProvider));
            }
            if (options.contains(IGenerationContextFactory.GenerationOption.MANAGED_BEAN)) {
                contextFactory.add((IGenerationContextFactory)new ManagedBeanFromSessionBeanGenContextFactory(webAppSDInfo, webFileProvider));
            }
            if (options.contains(IGenerationContextFactory.GenerationOption.JAVA_SERVICE)) {
                contextFactory.add((IGenerationContextFactory)new JavaServiceFromEntitiesGenContextFactory(modelSDInfo, modelFileProvider));
            }
            return contextFactory;
        }
        return null;
    }
}

