/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.common.technology.ADFCommonTechnologyExtension;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.document.AdfFaceletBinder;
import oracle.eclipse.tools.adf.view.document.AdfJspBinder;
import oracle.eclipse.tools.adf.view.internal.refactoring.AdfArtifactRefactoringService;
import oracle.eclipse.tools.adf.view.jsp.document.ControlCaseOutcomeProvider;
import oracle.eclipse.tools.adf.view.jsp.document.OutputTextFieldGenerator;
import oracle.eclipse.tools.adf.view.jsp.document.PanelFormLayoutFieldsGenerator;
import oracle.eclipse.tools.adf.view.jsp.document.TableGenerator;
import oracle.eclipse.tools.adf.view.jsp.document.ValueBindableComponentProviderForADF;
import oracle.eclipse.tools.adf.view.variables.internal.ImplicitVariableProviderForADF;
import oracle.eclipse.tools.application.common.services.appservices.IExpectedFacetService;
import oracle.eclipse.tools.application.common.services.appservices.TechExtensionVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IPreferredTagLibraryHandler;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.TechnologyToFacetMap;
import oracle.eclipse.tools.common.services.refactoring.IArtifactRefactoringService;
import oracle.eclipse.tools.common.services.techextservices.IDocumentBinder;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.jsp.document.FacesJSPUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ADFWebTechnologyExtension
extends ADFCommonTechnologyExtension
implements IPreferredTagLibraryHandler {
    public static final String ID = "adf.web";
    public static final String FACET_ID = "oracle.adf.web";
    private final TechnologyToFacetMap _techToFacetMap;
    private final Set<String> _supportedURIs;

    public ADFWebTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
        this._techToFacetMap = new TechnologyToFacetMap(project.getEclipseProject(), this.getTechExtDescriptor().getDiscovererInstance().getTechnologyDiscoveryProvider());
        this._supportedURIs = this.initializeUris();
    }

    private Set<String> initializeUris() {
        HashSet<String> uris = new HashSet<String>();
        uris.add("http://xmlns.oracle.com/adf/faces/rich");
        uris.add("http://xmlns.oracle.com/dss/adf/faces");
        uris.add("http://xmlns.oracle.com/dss/trinidad/faces");
        uris.add("http://xmlns.oracle.com/dynamic/adf/faces");
        uris.add("http://xmlns.oracle.com/adf/faces/databinding");
        return uris;
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        if (serviceType == IExpectedFacetService.class) {
            return (T)new IExpectedFacetService(){

                public Set<IProjectFacetVersion> getExpectedFacetVersion() {
                    return ADFWebTechnologyExtension.this._techToFacetMap.getExpectedFacets(ADFWebTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier());
                }

                public boolean hasCorrectFacets() {
                    Set<IProjectFacetVersion> expectedFacets = this.getExpectedFacetVersion();
                    boolean hasFacets = true;
                    for (IProjectFacetVersion expectedFacet : expectedFacets) {
                        try {
                            hasFacets &= FacetedProjectFramework.hasProjectFacet((IProject)ADFWebTechnologyExtension.this.getProject().getEclipseProject(), (String)expectedFacet.getProjectFacet().getId(), (String)expectedFacet.getVersionString());
                        }
                        catch (CoreException e) {
                            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (CoreException)e);
                            hasFacets = false;
                        }
                    }
                    return hasFacets;
                }
            };
        }
        if (serviceType == IPreferredTagLibraryHandler.class) {
            return (T)((Object)this);
        }
        if (serviceType == oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class) {
            return (T)new TechExtensionVersionProvider((AbstractTechnologyExtension)this, this._supportedURIs);
        }
        if (serviceType == IArtifactRefactoringService.class) {
            return (T)new AdfArtifactRefactoringService();
        }
        return (T)super.getAppService(serviceType);
    }

    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, final IDocument forDocument) {
        if (IImplicitVariableProvider.class.equals(serviceType)) {
            return new ImplicitVariableProviderForADF(forDocument);
        }
        if (IDocumentContentProvider.class.equals(serviceType)) {
            return new DocumentContentProviderForADF(forDocument);
        }
        if (IValueBindableComponentProvider.class.equals(serviceType)) {
            return new ValueBindableComponentProviderForADF(forDocument);
        }
        if (IVersionProvider.class.equals(serviceType)) {
            return new IVersionProvider(){

                public IDocument getDocument() {
                    return forDocument;
                }

                public IVersion getVersion(String nsId) {
                    oracle.eclipse.tools.application.common.services.appservices.IVersionProvider appService = ADFWebTechnologyExtension.this.getAppService(oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class);
                    if (appService != null) {
                        return appService.getVersion(nsId);
                    }
                    return null;
                }
            };
        }
        if (INavigationCaseProvider.class.equals(serviceType)) {
            return new ControlCaseOutcomeProvider(forDocument);
        }
        if (IDocumentBinder.class.equals(serviceType)) {
            if (forDocument.getDocumentType().equals("jsf.FaceletDocument")) {
                return new AdfFaceletBinder(forDocument);
            }
            if (forDocument.getDocumentType().equals("jsp.JSPDocument")) {
                return new AdfJspBinder(forDocument);
            }
        }
        return super.getDocumentService(serviceType, forDocument);
    }

    public IPreferredTagLibraryHandler.Preference handleTagLibrary(String uri) {
        if (uri.equals("http://xmlns.oracle.com/adf/faces/rich") || uri.equals("http://xmlns.oracle.com/dss/adf/faces")) {
            return IPreferredTagLibraryHandler.Preference.PREFERRED;
        }
        if (uri.equals("http://xmlns.oracle.com/dss/trinidad/faces") || uri.equals("http://xmlns.oracle.com/dynamic/adf/faces") || uri.equals("http://xmlns.oracle.com/adf/faces/databinding") || uri.equals("http://myfaces.apache.org/trinidad") || uri.equals("http://myfaces.apache.org/trinidad/html") || uri.equals("http://xmlns.oracle.com/adf/ui/jsp/adftags") || uri.equals("/webapp/DataTags.tld") || uri.equals("http://xmlns.oracle.com/adfinternal/faces/rich") || uri.equals("oracle.adf.businesseditor.declcomps")) {
            return IPreferredTagLibraryHandler.Preference.NOT_PREFERRED;
        }
        return IPreferredTagLibraryHandler.Preference.NOT_HANDLED;
    }

    private static class DocumentContentProviderForADF
    extends AbstractDocumentService
    implements IDocumentContentProvider {
        public DocumentContentProviderForADF(IDocument doc) {
            super(doc);
        }

        public int getPriority() {
            return 20;
        }

        public List<EnumVarGenerator> getEnumVarGenerators(ValueReference valRef) {
            ArrayList<EnumVarGenerator> results = new ArrayList<EnumVarGenerator>();
            IFile file = this.getDocument().getFile();
            if (this.isVisibleRef(valRef) && (FacesJSPUtil.isFacesPage((IDocument)this.getDocument()) || JSPUtil.isJSPFragment((IFile)file))) {
                results.add(new TableGenerator(this.getDocument()));
            }
            return results;
        }

        public List<FieldsGenerator> getFieldGenerators(ValueReference valRef) {
            ArrayList<FieldsGenerator> results = new ArrayList<FieldsGenerator>();
            IFile file = this.getDocument().getFile();
            if (this.isVisibleRef(valRef) && (FacesJSPUtil.isFacesPage((IDocument)this.getDocument()) || JSPUtil.isJSPFragment((IFile)file))) {
                FilePositionContext modelContext = new FilePositionContext(file);
                if (valRef.getType((IModelContext)modelContext).getNumFields((IModelContext)modelContext) > 0) {
                    results.add(new PanelFormLayoutFieldsGenerator(this.getDocument()));
                } else {
                    results.add(new OutputTextFieldGenerator(this.getDocument()));
                }
            }
            return results;
        }

        private boolean isVisibleRef(ValueReference valRef) {
            Variable.SCOPE scope = valRef.getVariable().getScope();
            return FacesJSPUtil.isVisibleValueRef((ValueReference)valRef) || scope == Variable.SCOPE.ADF_BACKING_BEAN_SCOPE || scope == Variable.SCOPE.ADF_PAGE_SCOPE || scope == Variable.SCOPE.ADF_VIEW_SCOPE;
        }
    }
}

