/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view;

import java.lang.ref.SoftReference;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.locator.ObjectLocatorManager;
import oracle.eclipse.tools.adf.view.variables.ProjectAndBindingVariablesCacheCleanupListener;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ADFPlugin
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.adf.view";
    private static ADFPlugin plugin;
    private ProjectAndBindingVariablesCacheCleanupListener projectCacheCleanupListener;
    private volatile SoftReference<IObjectLocator> objectLocatorReference;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.projectCacheCleanupListener = new ProjectAndBindingVariablesCacheCleanupListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this.projectCacheCleanupListener, 5);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.objectLocatorReference != null) {
            IObjectLocator locator = this.objectLocatorReference.get();
            if (locator != null) {
                locator.dispose();
            }
            this.objectLocatorReference = null;
        }
        super.stop(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.projectCacheCleanupListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectLocator _getObjectLocator() {
        if (this.objectLocatorReference == null || this.objectLocatorReference.get() == null) {
            if (plugin == null) {
                return null;
            }
            ADFPlugin aDFPlugin = this;
            synchronized (aDFPlugin) {
                if (this.objectLocatorReference == null || this.objectLocatorReference.get() == null) {
                    ObjectLocatorManager locator = new ObjectLocatorManager();
                    SoftReference<ObjectLocatorManager> aux = new SoftReference<ObjectLocatorManager>(locator);
                    this.objectLocatorReference = aux;
                }
            }
        }
        return this.objectLocatorReference.get();
    }

    public static ADFPlugin getDefault() {
        return plugin;
    }

    public static void logError(String msg, Throwable e) {
        ADFPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, e));
    }

    public static void log(Throwable e) {
        ADFPlugin.logError("Error", e);
    }

    public static void logInfo(String msg) {
        ADFPlugin.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, msg));
    }

    public static IObjectLocator getObjectLocator() {
        ADFPlugin p = ADFPlugin.getDefault();
        return p != null ? p._getObjectLocator() : null;
    }
}

