/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.markdown.core.LinkDefinition;
import org.eclipse.mylyn.internal.wikitext.markdown.core.LinkDefinitionParser;
import org.eclipse.mylyn.wikitext.core.parser.Locator;

public class LinkDefinitionUsageTracker {
    private final Locator locator;
    private final LinkDefinitionParser linkDefinitionParser;
    private final Set<String> usedLinkDefinitionIds;
    private final List<Position> missingLinkDefinitionPositions;

    public LinkDefinitionUsageTracker(Locator locator, LinkDefinitionParser linkDefinitionParser) {
        this.locator = locator;
        this.linkDefinitionParser = linkDefinitionParser;
        this.usedLinkDefinitionIds = new HashSet<String>();
        this.missingLinkDefinitionPositions = new ArrayList<Position>();
    }

    public void linkDefinitionRequested(String id) {
        LinkDefinition linkDefinition = this.linkDefinitionParser.getLinkDefinition(id);
        if (linkDefinition == null) {
            int offset = this.locator.getDocumentOffset();
            int length = this.locator.getLineSegmentEndOffset() - this.locator.getLineCharacterOffset();
            Position position = new Position(id, offset, length);
            this.missingLinkDefinitionPositions.add(position);
        } else {
            this.usedLinkDefinitionIds.add(id.toLowerCase());
        }
    }

    public List<Position> getUnusedLinkDefinitionPositions() {
        ArrayList<Position> usedLinkDefinitionPositions = new ArrayList<Position>();
        Map<String, LinkDefinition> linkDefinitions = this.linkDefinitionParser.getLinkDefinitions();
        for (Map.Entry<String, LinkDefinition> entry : linkDefinitions.entrySet()) {
            String id = entry.getKey();
            if (this.usedLinkDefinitionIds.contains(id.toLowerCase())) continue;
            LinkDefinition linkDefinition = entry.getValue();
            Position position = new Position(linkDefinition.getId(), linkDefinition.getOffset(), linkDefinition.getLength());
            usedLinkDefinitionPositions.add(position);
        }
        return usedLinkDefinitionPositions;
    }

    public List<Position> getMissingLinkDefinitionPositions() {
        return this.missingLinkDefinitionPositions;
    }

    public class Position {
        private final String id;
        int offset;
        int length;

        public Position(String id, int offset, int length) {
            this.id = id;
            this.offset = offset;
            this.length = length;
        }

        public String getId() {
            return this.id;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

