/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.common;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.ws.internal.ui.common.WidgetWithHistory;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public final class ComboWithHistory
extends Combo
implements WidgetWithHistory {
    private IDialogSettings settings_;

    public ComboWithHistory(Composite parent, int style, IDialogSettings settings) {
        super(parent, style);
        this.settings_ = settings;
    }

    public void restoreWidgetHistory(String restoreKey) {
        if (restoreKey == null || this.settings_ == null) {
            return;
        }
        String[] historyValues = this.settings_.getArray(restoreKey);
        if (historyValues == null || historyValues.length == 0) {
            return;
        }
        String[] existingItems = this.getItems();
        if (existingItems.length == 0) {
            int i = 0;
            while (i < historyValues.length) {
                if (historyValues[i] != null) {
                    this.add(historyValues[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < historyValues.length) {
                boolean foundInExistingItems = false;
                int j = 0;
                while (j < existingItems.length) {
                    if (existingItems[j].equals(historyValues[i])) {
                        foundInExistingItems = true;
                        break;
                    }
                    ++j;
                }
                if (!foundInExistingItems && historyValues[i] != null) {
                    this.add(historyValues[i]);
                }
                ++i;
            }
        }
    }

    protected void checkSubclass() {
    }

    public void storeWidgetHistory(String storeKey) {
        if (storeKey == null || this.settings_ == null) {
            return;
        }
        String currentlySelectedValue = this.getText();
        String[] oldHistoryValues = this.settings_.getArray(storeKey);
        if (oldHistoryValues == null) {
            oldHistoryValues = new String[]{};
        }
        ArrayList<String> newHistoryValues = new ArrayList<String>();
        int i = 0;
        while (i < oldHistoryValues.length && i < 5) {
            if (oldHistoryValues[i] != null && oldHistoryValues[i].trim().length() > 0 && !oldHistoryValues[i].equals(currentlySelectedValue)) {
                newHistoryValues.add(oldHistoryValues[i]);
            }
            ++i;
        }
        if (currentlySelectedValue.trim().length() > 0) {
            newHistoryValues.add(0, currentlySelectedValue);
        }
        oldHistoryValues = new String[newHistoryValues.size()];
        newHistoryValues.toArray(oldHistoryValues);
        this.settings_.put(storeKey, oldHistoryValues);
    }
}

