/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.util.IOperation;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public final class WlsRuntimeWorkspaceUpgradeParticipant
implements IWorkspaceUpgradeParticipant {
    private final Collection<IServerAdapterMetadataUpgradeParticipant> participants = new ArrayList<IServerAdapterMetadataUpgradeParticipant>();

    public WlsRuntimeWorkspaceUpgradeParticipant() {
        this.participants.add(new Wtp81AdapterMetadataUpgradeParticipant());
        this.participants.add(new Wtp90AdapterMetadataUpgradeParticipant());
        this.participants.add(new Wtp92AdapterMetadataUpgradeParticipant());
    }

    public boolean check() throws CoreException {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            for (IServerAdapterMetadataUpgradeParticipant participant : this.participants) {
                if (!participant.checkRuntime(runtime)) continue;
                return true;
            }
            ++n2;
        }
        iRuntimeArray = ServerCore.getServers();
        n = iRuntimeArray.length;
        n2 = 0;
        while (n2 < n) {
            IRuntime server = iRuntimeArray[n2];
            for (IServerAdapterMetadataUpgradeParticipant participant : this.participants) {
                if (!participant.checkServer((IServer)server)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IOperation operation = new IOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                int n = iRuntimeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntime runtime = iRuntimeArray[n2];
                    for (IServerAdapterMetadataUpgradeParticipant participant : WlsRuntimeWorkspaceUpgradeParticipant.this.participants) {
                        if (!participant.checkRuntime(runtime)) continue;
                        participant.convertRuntime(runtime);
                        break;
                    }
                    ++n2;
                }
                iRuntimeArray = ServerCore.getServers();
                n = iRuntimeArray.length;
                n2 = 0;
                while (n2 < n) {
                    IRuntime server = iRuntimeArray[n2];
                    for (IServerAdapterMetadataUpgradeParticipant participant : WlsRuntimeWorkspaceUpgradeParticipant.this.participants) {
                        if (!participant.checkServer((IServer)server)) continue;
                        participant.convertServer((IServer)server);
                        break;
                    }
                    ++n2;
                }
            }
        };
        ServerUtil.modifyServerCoreMetadata((IOperation)operation);
    }

    private static String getRuntimeTypeId(IRuntime runtime) {
        IRuntimeType runtimeType = runtime.getRuntimeType();
        if (runtimeType != null) {
            return runtimeType.getId();
        }
        return ((Base)runtime).getAttribute("runtime-type-id", null);
    }

    private static String getServerTypeId(IServer server) {
        IServerType serverType = server.getServerType();
        if (serverType != null) {
            return serverType.getId();
        }
        return ((Base)server).getAttribute("server-type-id", null);
    }

    private static abstract class AbstractWtpAdapterMetadataUpgradeParticipant
    implements IServerAdapterMetadataUpgradeParticipant {
        private String oldRuntimeTypeId;
        private String newRuntimeTypeId;
        private String oldServerTypeId;
        private String newServerTypeId;

        public AbstractWtpAdapterMetadataUpgradeParticipant(String oldRuntimeTypeId, String newRuntimeTypeId, String oldServerTypeId, String newServerTypeId) {
            this.oldRuntimeTypeId = oldRuntimeTypeId;
            this.newRuntimeTypeId = newRuntimeTypeId;
            this.oldServerTypeId = oldServerTypeId;
            this.newServerTypeId = newServerTypeId;
        }

        @Override
        public boolean checkRuntime(IRuntime runtime) {
            String runtimeTypeId = WlsRuntimeWorkspaceUpgradeParticipant.getRuntimeTypeId(runtime);
            return runtimeTypeId != null && runtimeTypeId.equals(this.oldRuntimeTypeId);
        }

        @Override
        public void convertRuntime(IRuntime runtime) throws CoreException {
            RuntimeWorkingCopy rwc = (RuntimeWorkingCopy)runtime.createWorkingCopy();
            rwc.setAttribute("runtime-type-id", this.newRuntimeTypeId);
            try {
                Method resolveMethod = Runtime.class.getDeclaredMethod("resolve", new Class[0]);
                resolveMethod.setAccessible(true);
                resolveMethod.invoke((Object)rwc, new Object[0]);
            }
            catch (Exception e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus(e));
            }
            rwc.save(true, null);
        }

        @Override
        public boolean checkServer(IServer server) {
            String serverTypeId = WlsRuntimeWorkspaceUpgradeParticipant.getServerTypeId(server);
            return serverTypeId != null && serverTypeId.equals(this.oldServerTypeId);
        }

        @Override
        public void convertServer(IServer server) throws CoreException {
            ServerWorkingCopy swc = (ServerWorkingCopy)server.createWorkingCopy();
            swc.setAttribute("server-type-id", this.newServerTypeId);
            swc.setAttribute("server-type", this.newServerTypeId);
            Map props = swc.getAttribute("generic_server_instance_properties", null);
            props.remove("autoDeployDirectory");
            props.remove("debugPort");
            props.remove("startScript");
            props.remove("stopScript");
            props.put("username", "weblogic");
            props.put("password", "weblogic");
            swc.setAttribute("generic_server_instance_properties", props);
            try {
                Method resolveMethod = Server.class.getDeclaredMethod("resolve", new Class[0]);
                resolveMethod.setAccessible(true);
                resolveMethod.invoke((Object)swc, new Object[0]);
            }
            catch (Exception e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus(e));
            }
            swc.save(true, null);
        }
    }

    private static interface IServerAdapterMetadataUpgradeParticipant {
        public boolean checkRuntime(IRuntime var1);

        public void convertRuntime(IRuntime var1) throws CoreException;

        public boolean checkServer(IServer var1);

        public void convertServer(IServer var1) throws CoreException;
    }

    private static final class Wtp81AdapterMetadataUpgradeParticipant
    extends AbstractWtpAdapterMetadataUpgradeParticipant {
        public Wtp81AdapterMetadataUpgradeParticipant() {
            super("org.eclipse.jst.server.generic.runtime.weblogic81", "com.bea.weblogic81.legacy", "org.eclipse.jst.server.generic.weblogic81", "com.bea.weblogic81.legacy.server");
        }
    }

    private static final class Wtp90AdapterMetadataUpgradeParticipant
    extends AbstractWtpAdapterMetadataUpgradeParticipant {
        public Wtp90AdapterMetadataUpgradeParticipant() {
            super("org.eclipse.jst.server.generic.runtime.weblogic90", "com.bea.weblogic90.legacy", "org.eclipse.jst.server.generic.weblogic90", "com.bea.weblogic90.legacy.server");
        }
    }

    private static final class Wtp92AdapterMetadataUpgradeParticipant
    implements IServerAdapterMetadataUpgradeParticipant {
        private Wtp92AdapterMetadataUpgradeParticipant() {
        }

        @Override
        public boolean checkRuntime(IRuntime runtime) {
            String runtimeTypeId = WlsRuntimeWorkspaceUpgradeParticipant.getRuntimeTypeId(runtime);
            return runtimeTypeId != null && runtimeTypeId.equals("org.eclipse.jst.server.generic.runtime.weblogic92");
        }

        @Override
        public void convertRuntime(IRuntime runtime) throws CoreException {
            String id = runtime.getId();
            Base r = (Base)runtime;
            Map props = r.getAttribute("generic_server_instance_properties", null);
            String wlhome = (String)props.get("serverRootDirectory");
            runtime.delete();
            WlsRuntimeUtil.createWlsRuntime(new File(wlhome), id);
        }

        @Override
        public boolean checkServer(IServer server) {
            String serverTypeId = WlsRuntimeWorkspaceUpgradeParticipant.getServerTypeId(server);
            return serverTypeId != null && serverTypeId.equals("org.eclipse.jst.server.generic.weblogic92");
        }

        @Override
        public void convertServer(IServer server) throws CoreException {
            server.getRuntime();
            String name = server.getName();
            Server svr = (Server)server;
            Map map = svr.getAttribute("generic_server_instance_properties", null);
            String domainPath = (String)map.get("domainDirectory");
            server.delete();
            IServerWorkingCopy newServer = WebLogicServerUtil.createWebLogicServer(server.getRuntime(), (IPath)new Path(domainPath), name);
            newServer.save(true, null);
        }
    }
}

