/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.util.ArrayList;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.IWorkspaceUpgradeParticipant;
import oracle.eclipse.tools.common.util.IOperation;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public final class Wls92ServerUpgradeParticipant
implements IWorkspaceUpgradeParticipant {
    private static final String PREVIOUS_SERVER_TYPE_ID = "com.bea.wlw.server";
    private static final String ATTR_WEBLOGIC_DOMAIN_PATH = "weblogic_domain_path";

    public boolean check() throws CoreException {
        return this.getPrevWls92Servers().length > 0;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IOperation operation = new IOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                IServer[] prev92servers;
                IServer[] iServerArray = prev92servers = Wls92ServerUpgradeParticipant.this.getPrevWls92Servers();
                int n = prev92servers.length;
                int n2 = 0;
                while (n2 < n) {
                    IServer iServer = iServerArray[n2];
                    if (iServer instanceof Server) {
                        Server server = (Server)iServer;
                        String domainPath = server.getAttribute(Wls92ServerUpgradeParticipant.ATTR_WEBLOGIC_DOMAIN_PATH, null);
                        ServerWorkingCopy serverWC = (ServerWorkingCopy)WebLogicServerUtil.createWebLogicServer(server.getRuntime(), (IPath)new Path(domainPath), server.getName());
                        IModule[] modules = server.getModules();
                        if (modules != null && modules.length > 0) {
                            serverWC.modifyModules(modules, new IModule[0], monitor);
                        }
                        serverWC.setAutoPublishSetting(server.getAutoPublishSetting());
                        serverWC.setAutoPublishTime(server.getAutoPublishTime());
                        serverWC.setHost(server.getHost());
                        serverWC.setMode(server.getMode());
                        serverWC.setFile(server.getFile());
                        serverWC.setPrivate(server.isPrivate());
                        serverWC.setReadOnly(server.isReadOnly());
                        serverWC.setServerConfiguration(server.getServerConfiguration());
                        serverWC.setServerPublishState(server.getServerPublishState());
                        serverWC.setServerRestartState(server.getServerRestartState());
                        serverWC.setServerState(server.getServerState());
                        serverWC.setServerStatus(server.getServerStatus());
                        boolean attr = server.getAttribute("IGNORE_COMPILER_ERRORS", false);
                        serverWC.setAttribute("IGNORE_COMPILER_ERRORS", attr);
                        attr = server.getAttribute("LAUNCH_BROWSER_AFTER_START", false);
                        serverWC.setAttribute("LAUNCH_BROWSER_AFTER_START", attr);
                        attr = server.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
                        serverWC.setAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", attr);
                        attr = server.getAttribute("START_SERVER_IN_CONSOLE", true);
                        serverWC.setAttribute("START_SERVER_IN_CONSOLE", attr);
                        iServer.delete();
                        serverWC.save(true, null);
                    }
                    ++n2;
                }
            }
        };
        ServerUtil.modifyServerCoreMetadata((IOperation)operation);
    }

    private IServer[] getPrevWls92Servers() throws CoreException {
        ArrayList<IServer> prevServers = new ArrayList<IServer>();
        Set<IServer> servers = WebLogicServerUtil.getWebLogicServers();
        for (IServer server : servers) {
            if (!this.isPrevVersionServer(server)) continue;
            prevServers.add(server);
        }
        return prevServers.toArray(new IServer[prevServers.size()]);
    }

    private boolean isPrevVersionServer(IServer server) throws CoreException {
        if (server.getServerType() != null) {
            String typeId = server.getServerType().getId();
            return PREVIOUS_SERVER_TYPE_ID.equals(typeId);
        }
        return true;
    }
}

