/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade.internal;

import java.io.File;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.upgrade.IDomainUpgradeCondition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class VersionMatchDomainUpgradeCondition
implements IDomainUpgradeCondition {
    private static final String CONFIG_XML_PATH = "config/config.xml";
    private static final String CONFIG_XML_PATH_IN_8_1 = "config.xml";
    private static final String EL_CONFIGURATION_VERSION = "configuration-version";
    private static final String EL_DOMAIN_VERSION = "domain-version";
    private static final String ATTR_CONFIGURATION_VERSION = "ConfigurationVersion";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IDomainUpgradeCondition.Result check(WebLogicServerInstall serverInstall, File domainLocation) {
        String domainVersion;
        File configXmlFile = new File(domainLocation, CONFIG_XML_PATH);
        if (configXmlFile.exists()) {
            Element root = DomUtil.root((File)configXmlFile);
            Element domainVersionElement = DomUtil.element((Element)root, (String)EL_DOMAIN_VERSION);
            if (domainVersionElement != null) {
                domainVersion = DomUtil.text((Node)domainVersionElement);
            } else {
                Element configVersionElement = DomUtil.element((Element)root, (String)EL_CONFIGURATION_VERSION);
                if (configVersionElement == null) return IDomainUpgradeCondition.Result.NO_UPGRADE_NEEDED;
                domainVersion = DomUtil.text((Node)configVersionElement);
            }
        } else {
            configXmlFile = new File(domainLocation, CONFIG_XML_PATH_IN_8_1);
            if (!configXmlFile.exists()) {
                return IDomainUpgradeCondition.Result.NO_UPGRADE_NEEDED;
            }
            domainVersion = DomUtil.root((File)configXmlFile).getAttribute(ATTR_CONFIGURATION_VERSION);
        }
        String serverVersion = serverInstall.getVersion().getVersionString();
        int[] parsedServerVersion = VersionMatchDomainUpgradeCondition.parseVersion(serverVersion);
        int[] parsedDomainVersion = VersionMatchDomainUpgradeCondition.parseVersion(domainVersion);
        if (parsedServerVersion == null || parsedDomainVersion == null) {
            return IDomainUpgradeCondition.Result.NO_UPGRADE_NEEDED;
        }
        int i = 0;
        while (i < 3) {
            if (VersionMatchDomainUpgradeCondition.segment(parsedServerVersion, i) > VersionMatchDomainUpgradeCondition.segment(parsedDomainVersion, i)) {
                if (i >= 2) return IDomainUpgradeCondition.Result.UPGRADE_AVAILABLE;
                return IDomainUpgradeCondition.Result.UPGRADE_REQUIRED;
            }
            ++i;
        }
        return IDomainUpgradeCondition.Result.NO_UPGRADE_NEEDED;
    }

    private static int[] parseVersion(String versionString) {
        String[] stringSegments = versionString.split("\\.");
        int[] intSegments = new int[stringSegments.length];
        int i = 0;
        while (i < stringSegments.length) {
            try {
                intSegments[i] = Integer.parseInt(stringSegments[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++i;
        }
        return intSegments;
    }

    private static int segment(int[] segments, int position) {
        if (position < segments.length) {
            return segments[position];
        }
        return 0;
    }
}

