/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade;

import java.io.File;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;

public interface IDomainUpgradeCondition {
    public Result check(WebLogicServerInstall var1, File var2);

    public static enum Result {
        NO_UPGRADE_NEEDED(1),
        UPGRADE_AVAILABLE(2),
        UPGRADE_REQUIRED(3);

        private int rank;

        private Result(int rank) {
            this.rank = rank;
        }

        public Result merge(Result result) {
            int maxRank = Math.max(this.rank, result.rank);
            if (maxRank == 1) {
                return NO_UPGRADE_NEEDED;
            }
            if (maxRank == 2) {
                return UPGRADE_AVAILABLE;
            }
            return UPGRADE_REQUIRED;
        }
    }
}

