/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade;

import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.common.util.wtp.ValidatorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class FacetsUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    public boolean check(IProject project) throws CoreException {
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return false;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            if (this.findUpgradeTask(ifacet.getFacetId(), ifacet.getVersion()) == null) continue;
            return true;
        }
        return false;
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        IFile f = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        boolean modified = false;
        boolean disableWSDLValidator = false;
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            String id = ifacet.getFacetId();
            UpgradeTask task = this.findUpgradeTask(id, ifacet.getVersion());
            if (task == null) continue;
            ifacet.setVersion(task.newVersion);
            modified = true;
            if (!id.equals("wls.web") && !id.equals("wls.utility")) continue;
            disableWSDLValidator = true;
        }
        if (modified) {
            md.save(project);
        }
        if (disableWSDLValidator) {
            ValidatorUtil.disableValidation((IProject)project, (String[])new String[]{"org.eclipse.wst.wsdl.validation.wsdl"});
        }
    }

    protected abstract Set<UpgradeTask> getUpgradeTasks();

    private UpgradeTask findUpgradeTask(String facetId, String version) {
        for (UpgradeTask task : this.getUpgradeTasks()) {
            if (!task.facetId.equals(facetId) || !task.oldVersion.equals(version)) continue;
            return task;
        }
        return null;
    }

    public static final class UpgradeTask {
        public final String facetId;
        public final String oldVersion;
        public final String newVersion;

        public UpgradeTask(String facetId, String oldVersion, String newVersion) {
            this.facetId = facetId;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
        }
    }
}

