/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.upgrade;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.upgrade.IDomainUpgradeCondition;
import org.eclipse.core.runtime.IConfigurationElement;

public final class DomainUpgradeConditionsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "domainUpgradeConditions";
    private static final String EL_CONDITION = "condition";
    private static final String ATTR_CLASS = "class";
    private static List<IDomainUpgradeCondition> conditions = null;

    public static synchronized List<IDomainUpgradeCondition> getConditions() {
        if (conditions == null) {
            ArrayList<IDomainUpgradeCondition> list = new ArrayList<IDomainUpgradeCondition>();
            for (PluginUtil.ClassInfo clinfo : DomainUpgradeConditionsExtensionPoint.readExtensions()) {
                IDomainUpgradeCondition condition = (IDomainUpgradeCondition)PluginUtil.instantiate((String)clinfo.pluginId, (String)clinfo.className, IDomainUpgradeCondition.class);
                if (condition == null) continue;
                list.add(condition);
            }
            conditions = Collections.unmodifiableList(list);
        }
        return conditions;
    }

    public static IDomainUpgradeCondition.Result checkConditions(WebLogicServerInstall wlsInstall, File domainLocation) {
        IDomainUpgradeCondition.Result result = IDomainUpgradeCondition.Result.NO_UPGRADE_NEEDED;
        for (IDomainUpgradeCondition condition : DomainUpgradeConditionsExtensionPoint.getConditions()) {
            try {
                result = result.merge(condition.check(wlsInstall, domainLocation));
            }
            catch (Exception e) {
                WlsCorePlugin.logException(e);
            }
        }
        return result;
    }

    private static List<PluginUtil.ClassInfo> readExtensions() {
        ArrayList<PluginUtil.ClassInfo> extensions = new ArrayList<PluginUtil.ClassInfo>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_CONDITION)) continue;
            try {
                String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                extensions.add(new PluginUtil.ClassInfo(pluginId, className));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        return extensions;
    }
}

