/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.syslib.IModuleReferenceSystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.IPathBasedSystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import oracle.eclipse.tools.weblogic.syslib.SystemLibraryProviderOperationConfig;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public abstract class SystemLibraryProviderOperation
extends LibraryProviderOperation {
    public final void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)1);
        try {
            IProject project = config.getFacetedProject().getProject();
            if (project == null) {
                String name = ((IFacetedProjectWorkingCopy)config.getFacetedProject()).getProjectName();
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            }
            try {
                ISystemLibrariesContainerDef definition = SystemLibrariesContainer.getContainerDef(project);
                SystemLibraryProviderOperationConfig cfg = (SystemLibraryProviderOperationConfig)config;
                this.execute(definition, cfg);
                definition.resource().save();
                definition.dispose();
            }
            catch (ResourceStoreException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    protected abstract void execute(ISystemLibrariesContainerDef var1, SystemLibraryProviderOperationConfig var2);

    protected final ISystemLibrary findMatchInList(ElementList<ISystemLibrary> libraries, ISystemLibrary library) {
        for (ISystemLibrary lib : libraries) {
            ISystemLibrary y;
            ISystemLibrary x;
            if (lib.getClass() != library.getClass()) continue;
            if (lib instanceof IPathBasedSystemLibrary) {
                x = (IPathBasedSystemLibrary)lib;
                y = (IPathBasedSystemLibrary)library;
                if (!SystemLibraryProviderOperation.equal(x.getLocationKey(), y.getLocationKey()) || !SystemLibraryProviderOperation.equal(x.getRelativePath(), y.getRelativePath())) continue;
                return lib;
            }
            x = (IModuleReferenceSystemLibrary)lib;
            y = (IModuleReferenceSystemLibrary)library;
            if (!SystemLibraryProviderOperation.equal(x.getModuleId(), y.getModuleId())) continue;
            return lib;
        }
        return null;
    }

    private static <T> boolean equal(Value<T> x, Value<T> y) {
        return ObjectUtil.equal((Object)x.text(true), (Object)y.text(true));
    }
}

