/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib.internal;

import java.io.File;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.syslib.IPathBasedSystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesLocation;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.DerivedValueServiceData;
import org.eclipse.sapphire.services.RelativePathService;

public final class PathBasedSystemLibraryServices {

    public static final class LibraryNameDerivedValueService
    extends DerivedValueService {
        protected void initDerivedValueService() {
            ((IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class)).getRelativePath().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    LibraryNameDerivedValueService.this.refresh();
                }
            });
        }

        protected DerivedValueServiceData compute() {
            String relativePathString = ((IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class)).getRelativePath().text();
            String libraryName = null;
            if (relativePathString != null) {
                Path relativePath = new Path(relativePathString);
                libraryName = relativePath.lastSegment();
            }
            return new DerivedValueServiceData(libraryName);
        }
    }

    public static final class RelativePathRelativePathService
    extends RelativePathService {
        protected void init() {
            super.init();
            ((IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class)).getLocationKey().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    RelativePathRelativePathService.this.broadcast();
                }
            });
        }

        public List<Path> roots() {
            SystemLibrariesLocation location;
            WebLogicServerInstall wlsInstall;
            IPathBasedSystemLibrary syslib = (IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class);
            Value<String> locationKeyValue = syslib.getLocationKey();
            if (locationKeyValue.validation().ok() && (wlsInstall = (WebLogicServerInstall)((ISystemLibrariesContainerDef)syslib.nearest(ISystemLibrariesContainerDef.class)).getWebLogicServerInstall().content()) != null && (location = wlsInstall.getSystemLibrariesLocation(locationKeyValue.text())) != null) {
                return Collections.singletonList(new Path(location.getPath().getPath()));
            }
            return Collections.emptyList();
        }
    }

    public static final class ResolvedPathDerivedValueService
    extends DerivedValueService {
        protected void initDerivedValueService() {
            FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    if (event instanceof PropertyContentEvent || event instanceof PropertyValidationEvent) {
                        ResolvedPathDerivedValueService.this.refresh();
                    }
                }
            };
            IPathBasedSystemLibrary library = (IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class);
            library.getLocationKey().attach((Listener)listener);
            library.getRelativePath().attach((Listener)listener);
        }

        protected DerivedValueServiceData compute() {
            IPathBasedSystemLibrary library = (IPathBasedSystemLibrary)this.context(IPathBasedSystemLibrary.class);
            WebLogicServerInstall wlsInstall = (WebLogicServerInstall)((ISystemLibrariesContainerDef)library.nearest(ISystemLibrariesContainerDef.class)).getWebLogicServerInstall().content();
            File path = null;
            if (wlsInstall != null) {
                Value<String> locationKeyValue = library.getLocationKey();
                Value<Path> relativePathValue = library.getRelativePath();
                if (locationKeyValue.validation().ok() && relativePathValue.validation().ok()) {
                    String locationKey = locationKeyValue.text(true);
                    String relativePath = relativePathValue.text();
                    SystemLibrariesLocation sysLibLocation = wlsInstall.getSystemLibrariesLocation(locationKey);
                    if (sysLibLocation != null) {
                        path = new File(sysLibLocation.getPath(), relativePath);
                    }
                }
            }
            return new DerivedValueServiceData(path != null ? path.getAbsolutePath() : null);
        }
    }
}

