/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib;

import java.io.UnsupportedEncodingException;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SystemLibraryProviderOperationConfig
extends LibraryProviderOperationConfig {
    private static final String PARAM_DEFINITION = "definition";
    private ISystemLibrariesContainerDef definition = null;

    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fproj, fv, provider);
        try {
            String def = (String)provider.getParams().get(PARAM_DEFINITION);
            byte[] defBytes = def.getBytes("UTF-8");
            this.definition = SystemLibrariesContainer.getContainerDef(defBytes);
            IRuntime runtime = fproj.getPrimaryRuntime();
            if (WlsRuntimeUtil.getWlsRuntimeComponent(runtime) != null) {
                this.definition.setWebLogicServerInstall(runtime.getName());
            }
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            WlsCorePlugin.logException(e);
        }
    }

    public ElementList<ISystemLibrary> getSystemLibraries() {
        if (this.definition == null || this.definition.disposed()) {
            return null;
        }
        return this.definition.getSystemLibraries();
    }

    public IStatus validate() {
        int severity;
        org.eclipse.sapphire.modeling.Status st = this.definition.validation();
        switch (st.severity()) {
            case ERROR: {
                severity = 4;
                break;
            }
            case WARNING: {
                severity = 2;
                break;
            }
            case OK: {
                severity = 0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new Status(severity, "oracle.eclipse.tools.weblogic", st.message());
    }

    public void dispose() {
        super.dispose();
        this.definition.dispose();
    }
}

