/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.syslib;

import java.io.InputStream;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.internal.SystemLibrariesContainerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class SystemLibrariesContainer {
    public static final String CONTAINER_ID = "oracle.eclipse.tools.weblogic.lib.system";
    public static final IPath CONTAINER_PATH = new Path("oracle.eclipse.tools.weblogic.lib.system");
    public static final String LEGACY_CONTAINER_ID = "com.bea.workshop.wls.syslib";
    public static final IPath LEGACY_CONTAINER_PATH = new Path("com.bea.workshop.wls.syslib");
    public static final String METADATA_FILE_NAME = "oracle.eclipse.tools.weblogic.syslib.xml";
    public static final String METADATA_FILE_PATH = ".settings/oracle.eclipse.tools.weblogic.syslib.xml";
    public static final String LEGACY_METADATA_FILE_NAME = "com.bea.workshop.wls.core.systemlibs.xml";
    public static final String LEGACY_METADATA_FILE_PATH = ".settings/com.bea.workshop.wls.core.systemlibs.xml";

    public static boolean isOnClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            return SystemLibrariesContainer.isOnClasspath(JavaCore.create((IProject)project));
        }
        return false;
    }

    public static boolean isOnClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry[] cp;
        IClasspathEntry[] iClasspathEntryArray = cp = project.getRawClasspath();
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SystemLibrariesContainer.isSystemLibrariesContainer(cpe)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addToClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            SystemLibrariesContainer.addToClasspath(JavaCore.create((IProject)project));
        }
    }

    public static void addToClasspath(IJavaProject project) throws CoreException {
        if (!SystemLibrariesContainer.isOnClasspath(project)) {
            IClasspathEntry[] oldcp = project.getRawClasspath();
            IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length + 1];
            System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
            newcp[newcp.length - 1] = JavaCore.newContainerEntry((IPath)CONTAINER_PATH);
            project.setRawClasspath(newcp, null);
        }
    }

    public static void removeFromClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            SystemLibrariesContainer.removeFromClasspath(JavaCore.create((IProject)project));
        }
    }

    public static void removeFromClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry[] oldcp = project.getRawClasspath();
        int i = 0;
        while (i < oldcp.length) {
            if (SystemLibrariesContainer.isSystemLibrariesContainer(oldcp[i])) {
                IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length - 1];
                System.arraycopy(oldcp, 0, newcp, 0, i);
                System.arraycopy(oldcp, i + 1, newcp, i, oldcp.length - i - 1);
                project.setRawClasspath(newcp, null);
                return;
            }
            ++i;
        }
    }

    public static boolean isSystemLibrariesContainer(IClasspathEntry cpe) {
        IPath path = cpe.getPath();
        return path.equals((Object)CONTAINER_PATH) || path.equals((Object)LEGACY_CONTAINER_PATH);
    }

    public static ISystemLibrariesContainerDef getContainerDef(IProject project) throws ResourceStoreException {
        IFile legacyFile;
        IFile file = project.getFile(METADATA_FILE_PATH);
        if (!file.exists() && (legacyFile = project.getFile(LEGACY_METADATA_FILE_PATH)).exists()) {
            file = legacyFile;
        }
        ISystemLibrariesContainerDef model = SystemLibrariesContainer.getContainerDef(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        if (!file.exists()) {
            model.addDefaultSystemLibraries();
        }
        return model;
    }

    public static ISystemLibrariesContainerDef getContainerDef(IJavaProject project) throws ResourceStoreException {
        return SystemLibrariesContainer.getContainerDef(project.getProject());
    }

    public static ISystemLibrariesContainerDef getContainerDef(byte[] definition) throws ResourceStoreException {
        return SystemLibrariesContainer.getContainerDef(new XmlResourceStore(new ByteArrayResourceStore(definition)));
    }

    public static ISystemLibrariesContainerDef getContainerDef(InputStream in) throws ResourceStoreException {
        return SystemLibrariesContainer.getContainerDef(new XmlResourceStore(new ByteArrayResourceStore(in)));
    }

    private static ISystemLibrariesContainerDef getContainerDef(XmlResourceStore xmlResourceStore) {
        return (ISystemLibrariesContainerDef)ISystemLibrariesContainerDef.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static void refreshContainer(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            SystemLibrariesContainer.refreshContainer(JavaCore.create((IProject)project));
        }
    }

    public static void refreshContainer(IJavaProject project) throws CoreException {
        SystemLibrariesContainerImpl newContainer;
        IClasspathContainer cont;
        SystemLibrariesContainerImpl existingContainer;
        IClasspathEntry[] cp = project.getRawClasspath();
        IPath containerPath = null;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SystemLibrariesContainer.isSystemLibrariesContainer(cpe)) {
                containerPath = cpe.getPath();
                break;
            }
            ++n2;
        }
        if (containerPath != null && !(existingContainer = (SystemLibrariesContainerImpl)(cont = JavaCore.getClasspathContainer(containerPath, (IJavaProject)project))).equals(newContainer = SystemLibrariesContainerImpl.createContainer(project, containerPath))) {
            IJavaProject[] projectsArray = new IJavaProject[]{project};
            IClasspathContainer[] containersArray = new IClasspathContainer[]{newContainer};
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projectsArray, (IClasspathContainer[])containersArray, null);
        }
    }

    private SystemLibrariesContainer() {
    }
}

