/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.properties.IModulePublishingTarget;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.WebLogicServerModelFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;

public class TargetNameValuesProvider
extends PossibleValuesService {
    private static HashMap<String, Set<String>> targetNameCache = new HashMap();

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.ERROR;
    }

    protected void fillPossibleValues(Set<String> values) {
        IWebLogicServerModel serverModel = (IWebLogicServerModel)this.context(IWebLogicServerModel.class);
        IServer server = WebLogicServerModelFactory.getServer();
        WeblogicServerBehaviour behavior = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        if (behavior.getWeblogicServer().isRemote()) {
            if (server.getServerState() == 2) {
                Set<String> cachedNames = targetNameCache.get(server.getId());
                if (cachedNames == null) {
                    IJ2EEDeploymentHelper helper = behavior.getPublisher();
                    if (helper == null) {
                        return;
                    }
                    try {
                        IWlsJMXHelper JMXHelper = helper.getWlsJMXHelper();
                        values.addAll(JMXHelper.getServers());
                        values.addAll(JMXHelper.getClusters().keySet());
                    }
                    catch (Exception exception) {}
                    targetNameCache.put(server.getId(), values);
                    TargetNameValuesProvider.addServerListener(server);
                } else {
                    values.addAll(cachedNames);
                }
            } else {
                values.add("AdminServer");
                if (serverModel == null) {
                    return;
                }
                for (IModulePublishingTarget t : serverModel.getModulePublishingTargets()) {
                    String name = (String)t.getTargetName().content();
                    if (name == null) continue;
                    values.add(name);
                }
            }
        } else {
            ServerInfo info = behavior.getWeblogicServer().getServerInfo();
            if (info == null) {
                return;
            }
            values.add(info.getServerName());
            Set<String> clusterNames = info.getClusterNames();
            List<ServerInfo> serverInfoList = info.getManagedServerList();
            for (ServerInfo s : serverInfoList) {
                if (clusterNames.contains(s.getCluster())) continue;
                values.add(s.getServerName());
            }
            for (String c : clusterNames) {
                values.add(c);
            }
        }
    }

    private static void addServerListener(final IServer thisServer) {
        final IServerListener listener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if (event.getState() == 4) {
                    targetNameCache.remove(event.getServer().getId());
                    event.getServer().removeServerListener((IServerListener)this);
                }
            }
        };
        thisServer.addServerListener(listener);
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)new IServerLifecycleListener(){

            public void serverRemoved(IServer server) {
                if (server.getId().equals(thisServer.getId())) {
                    targetNameCache.remove(server.getId());
                    server.removeServerListener(listener);
                    ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
                }
            }

            public void serverChanged(IServer server) {
            }

            public void serverAdded(IServer server) {
            }
        });
    }
}

