/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties.internal;

import oracle.eclipse.tools.weblogic.server.properties.IModulePublishingTarget;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.PublishMode;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PublishTargetValidator
extends ValidationService {
    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(IModulePublishingTarget.class));
        IWebLogicServerModel model = (IWebLogicServerModel)list.element();
        String adminServer = (String)model.getAdminServer().content();
        Value val = model.getPublishMode();
        if (val.content(false) != null && val.content() == PublishMode.SPLIT_SOURCE) {
            IModulePublishingTarget t;
            String name;
            if (list.size() == 1 && (name = (String)(t = (IModulePublishingTarget)list.get(0)).getTargetName().content()) != null && !name.equals(adminServer)) {
                return Status.createErrorStatus((String)"Publishing to managed server or cluster is not supported in virtual application publishing mode.");
            }
            if (list.size() > 1) {
                return Status.createErrorStatus((String)"Publishing to managed servers or clusters is not supported in virtual application publishing mode.");
            }
            return Status.createOkStatus();
        }
        if (val.content(false) == null) {
            if (list.size() == 1) {
                IModulePublishingTarget t = (IModulePublishingTarget)list.get(0);
                String name = (String)t.getTargetName().content();
                if (adminServer != null && name != null && !adminServer.equals(name)) {
                    model.setPublishMode(PublishMode.EXPLODED_ARCHIVE);
                }
            }
            if (list.size() > 1) {
                model.setPublishMode(PublishMode.EXPLODED_ARCHIVE);
            }
        }
        return Status.createOkStatus();
    }
}

