/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties.internal;

import oracle.eclipse.tools.weblogic.server.properties.IModulePublishingTarget;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.PublishMode;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PublishModeValidator
extends ValidationService {
    protected Status compute() {
        Value mode = (Value)this.context(Value.class);
        IWebLogicServerModel model = (IWebLogicServerModel)mode.element();
        if (mode.content() == PublishMode.SPLIT_SOURCE) {
            ElementList list = model.getModulePublishingTargets();
            if (list.size() == 1) {
                IModulePublishingTarget t = (IModulePublishingTarget)list.get(0);
                String adminServer = (String)model.getAdminServer().content();
                if (adminServer != null && !adminServer.equals(t.getTargetName().content())) {
                    return Status.createErrorStatus((String)"Managed server or cluster in Advanced settings is not supported in virtual application publishing mode.");
                }
            }
            if (list.size() > 1) {
                return Status.createErrorStatus((String)"Managed servers or clusters in Advanced settings is not supported in virtual application publishing mode.");
            }
            if (model.getModuleDeploymentOptions().size() > 0) {
                return Status.createErrorStatus((String)"Deployment plan specified in Advanced settings is not supported in virtual application publishing mode.");
            }
        }
        return Status.createOkStatus();
    }
}

