/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DeploymentPlanValidator
extends ValidationService {
    protected Status compute() {
        Value path = (Value)this.context(Value.class);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.content() != null) {
            IFile[] files;
            org.eclipse.sapphire.modeling.Path wsPath = (org.eclipse.sapphire.modeling.Path)path.content();
            if (!wsPath.toFile().exists()) {
                wsPath = new org.eclipse.sapphire.modeling.Path(String.valueOf(root.getLocation().toOSString()) + '/' + wsPath.toOSString());
            }
            if ((files = root.findFilesForLocation((IPath)new Path(wsPath.toPortableString()))).length > 0) {
                IFile file = files[0];
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                try {
                    IContentDescription contentDescription = contentTypeManager.getDescriptionFor(file.getContents(), file.getName(), IContentDescription.ALL);
                    if (contentDescription != null) {
                        String contentTypeId = contentDescription.getContentType().getId();
                        if (contentTypeId.equals("oracle.eclipse.tools.weblogic.descriptors.DeploymentPlan")) {
                            return Status.createOkStatus();
                        }
                        return Status.createErrorStatus((String)"Selected file is not a valid deployment plan.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return Status.createOkStatus();
        }
        return Status.createErrorStatus((String)"Deployment plan must be specified.");
    }
}

