/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.WebLogicServerModelResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UseSSLPortValidationService
extends ValidationService {
    protected Status compute() {
        boolean isUseSSL = (Boolean)((Value)this.context(Value.class)).content();
        IWebLogicServerModel serverModel = (IWebLogicServerModel)this.context(Element.class);
        WebLogicServerModelResource res = (WebLogicServerModelResource)serverModel.resource();
        IWeblogicServer wlsServer = (IWeblogicServer)res.getServerWorkingCopy().getOriginal().getAdapter(IWeblogicServer.class);
        if (wlsServer != null && !wlsServer.isRemote()) {
            boolean listenPortDisabled = wlsServer.getServerInfo().isListenPortDisabled();
            if (!isUseSSL && listenPortDisabled) {
                return Status.createStatus((Status.Severity)Status.Severity.ERROR, (String)"Use SSL Port must be selected when HTTP port is disabled.");
            }
        }
        return Status.createOkStatus();
    }
}

