/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.weblogic.server.properties.IModuleDeploymentOptionsModel;
import oracle.eclipse.tools.weblogic.server.properties.WebLogicServerModelResource;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class ModuleDeploymentOptionsModelResource
extends Resource {
    private String optionString = null;
    private String moduleName = null;
    private String deploymentPlan = null;

    public ModuleDeploymentOptionsModelResource(Resource parent, Object obj) {
        super(parent);
        this.optionString = obj.toString();
        this.parseOptionString();
    }

    public IServerWorkingCopy getServerWorkingCopy() {
        return ((WebLogicServerModelResource)this.parent()).getServerWorkingCopy();
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IModuleDeploymentOptionsModel.PROP_MODULE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return ModuleDeploymentOptionsModelResource.this.moduleName;
                }

                public void write(String value) {
                    ModuleDeploymentOptionsModelResource.this.saveChanges(value, ModuleDeploymentOptionsModelResource.this.deploymentPlan);
                    ModuleDeploymentOptionsModelResource.this.moduleName = value;
                }
            };
        }
        if (p == IModuleDeploymentOptionsModel.PROP_DEPLOYMENT_PLAN) {
            return new ValuePropertyBinding(){

                public String read() {
                    return ModuleDeploymentOptionsModelResource.this.deploymentPlan;
                }

                public void write(String value) {
                    ModuleDeploymentOptionsModelResource.this.saveChanges(ModuleDeploymentOptionsModelResource.this.moduleName, value);
                    ModuleDeploymentOptionsModelResource.this.deploymentPlan = value;
                }
            };
        }
        return null;
    }

    private void parseOptionString() {
        String[] options;
        String[] stringArray = options = this.optionString.split(",");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.startsWith("deployplan=")) {
                this.deploymentPlan = option.substring(option.indexOf(61) + 1);
            }
            if (option.startsWith("name=")) {
                this.moduleName = option.substring(option.indexOf(61) + 1);
            }
            ++n2;
        }
    }

    private void saveChanges(String module, String deployPlan) {
        IServerWorkingCopy swc = this.getServerWorkingCopy();
        List moduleDeployOptions = swc.getAttribute("module_deploy_options", new ArrayList());
        String option = "name=" + module + ',' + "deployplan=" + deployPlan;
        Iterator it = moduleDeployOptions.iterator();
        while (it.hasNext()) {
            String[] map;
            String s = (String)it.next();
            if (s.length() == 0 || (map = s.split(",")).length <= 1) continue;
            String name = map[0].substring(map[0].indexOf(61) + 1);
            String deployplan = map[1].substring(map[1].indexOf(61) + 1);
            if (!name.equals(this.moduleName) || !deployplan.equals(this.deploymentPlan)) continue;
            it.remove();
        }
        moduleDeployOptions.add(option);
        swc.setAttribute("module_deploy_options", moduleDeployOptions);
    }

    public String getOptionString() {
        return "name=" + this.moduleName + ',' + "deployplan=" + this.deploymentPlan;
    }
}

