/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.properties;

import oracle.eclipse.tools.weblogic.server.properties.UseSSLPortValidationService;
import oracle.eclipse.tools.weblogic.server.properties.internal.DomainPathValidator;
import oracle.eclipse.tools.weblogic.server.properties.internal.RemoteServerPasswordValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

public interface IServerProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IServerProperties.class);
    @Label(standard="&domain home")
    @Service(impl=DomainPathValidator.class)
    @ReadOnly
    public static final ValueProperty PROP_DOMAIN_HOME = new ValueProperty(TYPE, "DomainHome");
    @Label(standard="domain &version")
    @ReadOnly
    public static final ValueProperty PROP_DOMAIN_VERSION = new ValueProperty(TYPE, "DomainVersion");
    @Label(standard="domain &name")
    @Enablement(expr="false")
    public static final ValueProperty PROP_DOMAIN_NAME = new ValueProperty(TYPE, "DomainName");
    @Label(standard="ad&min server name")
    @Enablement(expr="false")
    public static final ValueProperty PROP_ADMIN_SERVER = new ValueProperty(TYPE, "AdminServer");
    @Label(standard="&port number")
    @Type(base=Integer.class)
    @DefaultValue(text="7001")
    @ReadOnly
    @Enablement(expr="${ ServerType == 'REMOTE_SERVER' }")
    public static final ValueProperty PROP_PORT = new ValueProperty(TYPE, "Port");
    @Label(standard="&HTTPS Port")
    @DefaultValue(text="7002")
    @Enablement(expr="${ ServerType == 'REMOTE_SERVER' && ServerDisconnected == 'true' }")
    public static final ValueProperty PROP_HTTPS_PORT = new ValueProperty(TYPE, "HttpsPort");
    @Label(standard="&listening address")
    @ReadOnly
    public static final ValueProperty PROP_LISTENING_ADDRESS = new ValueProperty(TYPE, "ListeningAddress");
    @Label(standard="&remote host")
    @Required
    @DefaultValue(text="localhost")
    @Enablement(expr="${ ServerDisconnected == 'true' }")
    public static final ValueProperty PROP_REMOTE_HOST = new ValueProperty(TYPE, "RemoteHost");
    @Label(standard="admin server por&t")
    @Type(base=Integer.class)
    @Required
    @DefaultValue(text="7001")
    @Enablement(expr="${ ServerDisconnected == 'true' }")
    public static final ValueProperty PROP_REMOTE_PORT = new ValueProperty(TYPE, "RemotePort");
    @Label(standard="Us&e SSL port")
    @Type(base=Boolean.class)
    @Required
    @DefaultValue(text="false")
    @Enablement(expr="${ HttpsPort != null }")
    @Service(impl=UseSSLPortValidationService.class)
    public static final ValueProperty PROP_USE_SSL_PORT = new ValueProperty(TYPE, "UseSSLPort");
    @Label(standard="Use HTTP tu&nneling")
    @Type(base=Boolean.class)
    @Required
    @DefaultValue(text="false")
    public static final ValueProperty PROP_USE_TUNNELING = new ValueProperty(TYPE, "UseTunneling");
    @Label(standard="debu&g port")
    @Type(base=Integer.class)
    @Required
    @DefaultValue(text="8453")
    @Enablement(expr="${ ServerDisconnected == 'true' }")
    @Documentation(content="Enter the debug connection port that the WebLogic Server listens to when it is started in debug mode. ")
    public static final ValueProperty PROP_DEBUG_PORT = new ValueProperty(TYPE, "DebugPort");
    @Label(standard="&user name")
    @Required
    @DefaultValue(text="weblogic")
    @Enablement(expr="${ ServerDisconnected == 'true' }")
    public static final ValueProperty PROP_USER_NAME = new ValueProperty(TYPE, "UserName");
    @Label(standard="&password")
    @SensitiveData
    @Required
    @Service(impl=RemoteServerPasswordValidator.class)
    @Enablement(expr="${ ServerDisconnected == 'true' }")
    public static final ValueProperty PROP_PASSWORD = new ValueProperty(TYPE, "Password");

    public Value<String> getDomainHome();

    public void setDomainHome(String var1);

    public Value<String> getDomainVersion();

    public Value<String> getDomainName();

    public void setDomainName(String var1);

    public Value<String> getAdminServer();

    public void setAdminServer(String var1);

    public Value<Integer> getPort();

    public Value<String> getHttpsPort();

    public void setHttpsPort(String var1);

    public Value<String> getListeningAddress();

    public Value<String> getRemoteHost();

    public void setRemoteHost(String var1);

    public Value<Integer> getRemotePort();

    public void setRemotePort(String var1);

    public void setRemotePort(Integer var1);

    public Value<Boolean> isUseSSLPort();

    public void setUseSSLPort(String var1);

    public void setUseSSLPort(Boolean var1);

    public Value<Boolean> isUseTunneling();

    public void setUseTunneling(String var1);

    public void setUseTunneling(Boolean var1);

    public Value<Integer> getDebugPort();

    public void setDebugPort(String var1);

    public void setDebugPort(Integer var1);

    public Value<String> getUserName();

    public void setUserName(String var1);

    public Value<String> getPassword();

    public void setPassword(String var1);
}

